/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class OwnableFenceGateBlock
extends FenceGateBlock
implements EntityBlock {
    protected final SoundEvent openSound;
    protected final SoundEvent closeSound;

    public OwnableFenceGateBlock(BlockBehaviour.Properties properties, WoodType woodType) {
        super(properties, woodType);
        this.openSound = woodType.f_271162_();
        this.closeSound = woodType.f_271365_();
    }

    public OwnableFenceGateBlock(BlockBehaviour.Properties properties, SoundEvent openSound, SoundEvent closeSound) {
        super(properties, openSound, closeSound);
        this.openSound = openSound;
        this.closeSound = closeSound;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.m_5880_(x$0, x$1, x$2, x$3), state, player, level, pos);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return (Boolean)ConfigHandler.SERVER.alwaysDrop.get() != false || super.canHarvestBlock(state, level, pos, player);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (placer instanceof Player) {
            Player player = (Player)placer;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof INameSetter) {
            INameSetter nameable = (INameSetter)blockEntity;
            nameable.setCustomName(stack.m_41786_());
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean hasActiveSCBlock = BlockUtils.hasActiveSCBlockNextTo(context.m_43725_(), context.m_8083_());
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)f_53341_, (Comparable)Boolean.valueOf(hasActiveSCBlock))).m_61124_((Property)f_53342_, (Comparable)Boolean.valueOf(hasActiveSCBlock));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_) {
            boolean isPoweredSCBlock = BlockUtils.hasActiveSCBlockNextTo(level, pos);
            if ((Boolean)state.m_61143_((Property)f_53342_) != isPoweredSCBlock) {
                level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)f_53342_, (Comparable)Boolean.valueOf(isPoweredSCBlock))).m_61124_((Property)f_53341_, (Comparable)Boolean.valueOf(isPoweredSCBlock)), 2);
                if ((Boolean)state.m_61143_((Property)f_53341_) != isPoweredSCBlock) {
                    level.m_5594_(null, pos, isPoweredSCBlock ? this.openSound : this.closeSound, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
                    level.m_142346_(null, isPoweredSCBlock ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
                }
            }
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity(pos, state);
    }
}

