/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.entity.camera.CameraViewAreaExtension;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.phys.AABB;

public class CameraFeed {
    private final Set<BlockPos> linkedFrames = new HashSet<BlockPos>();
    private final AtomicDouble lastActiveTime = new AtomicDouble();
    private final List<LevelRenderer.RenderChunkInfo> sectionsInRange = new ArrayList<LevelRenderer.RenderChunkInfo>();
    private final Set<Long> sectionsInRangePositions = new HashSet<Long>();
    private final List<LevelRenderer.RenderChunkInfo> visibleSections = new ArrayList<LevelRenderer.RenderChunkInfo>();
    private final List<LevelRenderer.RenderChunkInfo> compilingSectionsQueue = new ArrayList<LevelRenderer.RenderChunkInfo>();
    private final RenderTarget renderTarget;
    private boolean requiresFrustumUpdate = false;

    public CameraFeed(GlobalPos globalPos, LevelRenderer.RenderChunkInfo startingSection) {
        int resolution = (Integer)ConfigHandler.CLIENT.frameFeedResolution.get();
        this.renderTarget = new TextureTarget(resolution, resolution, true, Minecraft.f_91002_);
        this.compilingSectionsQueue.add(startingSection);
        this.sectionsInRange.add(startingSection);
        this.sectionsInRangePositions.add(startingSection.f_109839_.m_112839_().m_121878_());
        this.discoverVisibleSections(globalPos, FrameFeedHandler.getFrameFeedViewDistance(null));
    }

    public void requestFrustumUpdate() {
        this.requiresFrustumUpdate = true;
    }

    public boolean requiresFrustumUpdate() {
        return this.requiresFrustumUpdate;
    }

    public void discoverVisibleSections(GlobalPos cameraPos, int viewDistance) {
        SectionPos cameraSectionPos = SectionPos.m_123199_((BlockPos)cameraPos.m_122646_());
        ArrayDeque<LevelRenderer.RenderChunkInfo> queueToCheck = new ArrayDeque<LevelRenderer.RenderChunkInfo>(this.compilingSectionsQueue);
        this.compilingSectionsQueue.clear();
        while (!queueToCheck.isEmpty()) {
            LevelRenderer.RenderChunkInfo currentSectionInfo = (LevelRenderer.RenderChunkInfo)queueToCheck.poll();
            ChunkRenderDispatcher.RenderChunk currentSection = currentSectionInfo.f_109839_;
            BlockPos origin = currentSection.m_112839_();
            ChunkRenderDispatcher.CompiledChunk currentCompiledSection = currentSection.m_112835_();
            if (currentCompiledSection == ChunkRenderDispatcher.CompiledChunk.f_112748_) {
                this.compilingSectionsQueue.add(currentSectionInfo);
                continue;
            }
            for (Direction dir : Direction.values()) {
                long neighbourPosAsLong;
                ChunkRenderDispatcher.RenderChunk neighbourSection;
                int cx = SectionPos.m_123171_((int)origin.m_123341_()) + dir.m_122429_();
                int cy = SectionPos.m_123171_((int)origin.m_123342_()) + dir.m_122430_();
                int cz = SectionPos.m_123171_((int)origin.m_123343_()) + dir.m_122431_();
                if (!Utils.isInViewDistance(cameraSectionPos.m_123170_(), cameraSectionPos.m_123222_(), viewDistance, cx, cz) || (neighbourSection = CameraViewAreaExtension.rawFetch(cx, cy, cz, true)) == null || this.sectionsInRangePositions.contains(neighbourPosAsLong = neighbourSection.m_112839_().m_121878_()) || !this.canSeeNeighborFace(currentCompiledSection, dir)) continue;
                LevelRenderer.RenderChunkInfo neighbourChunkInfo = new LevelRenderer.RenderChunkInfo(neighbourSection, null, 0);
                this.sectionsInRange.add(neighbourChunkInfo);
                this.sectionsInRangePositions.add(neighbourSection.m_112839_().m_121878_());
                this.compilingSectionsQueue.add(neighbourChunkInfo);
                this.requestFrustumUpdate();
            }
        }
    }

    private boolean canSeeNeighborFace(ChunkRenderDispatcher.CompiledChunk currentCompiledSection, Direction dir) {
        for (int j = 0; j < Direction.values().length; ++j) {
            if (!currentCompiledSection.m_7259_(Direction.values()[j].m_122424_(), dir)) continue;
            return true;
        }
        return false;
    }

    public void updateVisibleSections(Frustum frustum) {
        this.requiresFrustumUpdate = false;
        this.visibleSections.clear();
        for (LevelRenderer.RenderChunkInfo section : this.sectionsInRange) {
            if (!frustum.m_113029_(section.f_109839_.m_202440_())) continue;
            this.visibleSections.add(section);
        }
    }

    public void applyVisibleSections(List<LevelRenderer.RenderChunkInfo> currentVisibleSections) {
        currentVisibleSections.clear();
        currentVisibleSections.addAll(this.visibleSections);
    }

    public boolean hasVisibleSections() {
        return !this.visibleSections.isEmpty();
    }

    public boolean hasFrameInFrustum(Frustum frustum) {
        for (BlockPos framePos : this.linkedFrames) {
            if (!frustum.m_113029_(new AABB(framePos))) continue;
            return true;
        }
        return false;
    }

    public void linkFrame(FrameBlockEntity be) {
        this.linkedFrames.add(be.m_58899_());
    }

    public void unlinkFrame(FrameBlockEntity be) {
        this.linkedFrames.remove(be.m_58899_());
    }

    public boolean isFrameLinked(FrameBlockEntity be) {
        return this.linkedFrames.contains(be.m_58899_());
    }

    public void markForRemoval() {
        this.linkedFrames.clear();
    }

    public boolean shouldBeRemoved() {
        return this.linkedFrames.isEmpty();
    }

    public AtomicDouble lastActiveTime() {
        return this.lastActiveTime;
    }

    public RenderTarget renderTarget() {
        return this.renderTarget;
    }
}

