/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.sentry;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Optional;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IEMPAffected;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.SometimesVisibleBlock;
import net.geforcemods.securitycraft.entity.sentry.AttackRangedIfEnabledGoal;
import net.geforcemods.securitycraft.entity.sentry.Bullet;
import net.geforcemods.securitycraft.entity.sentry.ISentryBulletContainer;
import net.geforcemods.securitycraft.entity.sentry.TargetNearestPlayerOrMobGoal;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class Sentry
extends PathfinderMob
implements RangedAttackMob,
IEMPAffected,
IOwnable {
    private static final EntityDataAccessor<Owner> OWNER = SynchedEntityData.m_135353_(Sentry.class, Owner.getSerializer());
    private static final EntityDataAccessor<CompoundTag> ALLOWLIST = SynchedEntityData.m_135353_(Sentry.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Boolean> HAS_SPEED_MODULE = SynchedEntityData.m_135353_(Sentry.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MODE = SynchedEntityData.m_135353_(Sentry.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_TARGET = SynchedEntityData.m_135353_(Sentry.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHUT_DOWN = SynchedEntityData.m_135353_(Sentry.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> HEAD_ROTATION = SynchedEntityData.m_135353_(Sentry.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final float MAX_TARGET_DISTANCE = 20.0f;
    private static final float ANIMATION_STEP_SIZE = 0.025f;
    private static final float UPWARDS_ANIMATION_LIMIT = 0.025f;
    private static final float DOWNWARDS_ANIMATION_LIMIT = 0.9f;
    private float headYTranslation = 0.9f;
    private float oHeadYTranslation = 0.9f;
    private boolean animateUpwards = false;
    private boolean animate = false;
    private float headRotation;
    private float oHeadRotation;
    private boolean hasReceivedEntityData = false;

    public Sentry(EntityType<Sentry> type, Level level) {
        super((EntityType)SCContent.SENTRY_ENTITY.get(), level);
    }

    public void setUpSentry(Player player) {
        this.f_19804_.m_135381_(OWNER, (Object)new Owner(player.m_7755_().getString(), UUIDUtil.m_235875_((GameProfile)player.m_36316_()).toString()));
        this.f_19804_.m_135381_(ALLOWLIST, (Object)new CompoundTag());
        this.f_19804_.m_135381_(HAS_SPEED_MODULE, (Object)false);
        this.f_19804_.m_135381_(MODE, (Object)SentryMode.CAMOUFLAGE_HP.ordinal());
        this.f_19804_.m_135381_(HAS_TARGET, (Object)false);
        this.f_19804_.m_135381_(SHUT_DOWN, (Object)false);
        this.f_19804_.m_135381_(HEAD_ROTATION, (Object)Float.valueOf((float)(Mth.m_14136_((double)(player.m_20185_() - this.m_20185_()), (double)(-(player.m_20189_() - this.m_20189_()))) * 57.29577951308232)));
        this.getSentryDisguiseBlockEntity();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER, (Object)new Owner());
        this.f_19804_.m_135372_(ALLOWLIST, (Object)new CompoundTag());
        this.f_19804_.m_135372_(HAS_SPEED_MODULE, (Object)false);
        this.f_19804_.m_135372_(MODE, (Object)SentryMode.CAMOUFLAGE_HP.ordinal());
        this.f_19804_.m_135372_(HAS_TARGET, (Object)false);
        this.f_19804_.m_135372_(SHUT_DOWN, (Object)false);
        this.f_19804_.m_135372_(HEAD_ROTATION, (Object)Float.valueOf(0.0f));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new AttackRangedIfEnabledGoal(this, this::getShootingSpeed, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new TargetNearestPlayerOrMobGoal(this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            BlockPos downPos = this.m_20099_();
            if (this.m_9236_().m_8055_(downPos).m_60795_() || this.m_9236_().m_45772_(new AABB(downPos))) {
                this.m_146870_();
            }
        } else {
            this.oHeadRotation = this.getHeadRotation();
            this.headRotation = ((Float)this.f_19804_.m_135370_(HEAD_ROTATION)).floatValue();
            this.oHeadYTranslation = this.headYTranslation;
            if (this.shouldHeadBeUp()) {
                if (this.headYTranslation > 0.025f) {
                    this.setAnimateUpwards(true);
                    this.setAnimate(true);
                }
            } else if (this.headYTranslation < 0.9f) {
                this.setAnimateUpwards(false);
                this.setAnimate(true);
            }
            if (this.isAnimating()) {
                if (this.animatesUpwards() && this.headYTranslation > 0.025f) {
                    this.headYTranslation -= 0.025f;
                    if (this.headYTranslation <= 0.025f) {
                        this.setAnimateUpwards(false);
                        this.setAnimate(false);
                    }
                } else if (!this.animatesUpwards() && this.headYTranslation < 0.9f) {
                    this.headYTranslation += 0.025f;
                    if (this.headYTranslation >= 0.9f) {
                        this.setAnimateUpwards(true);
                        this.setAnimate(false);
                    }
                }
            }
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)SCContent.SENTRY.get());
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        BlockPos pos = this.m_20183_();
        if (this.isOwnedBy((Entity)player) && hand == InteractionHand.MAIN_HAND) {
            Item item = player.m_21205_().m_41720_();
            player.m_6915_();
            if (player.m_6047_()) {
                this.m_6074_();
            } else if (item == Items.f_42451_ && this.isShutDown()) {
                this.reactivate();
                if (!player.m_7500_()) {
                    player.m_21205_().m_41774_(1);
                }
            } else if (item == SCContent.UNIVERSAL_BLOCK_REMOVER.get() && !((Boolean)ConfigHandler.SERVER.vanillaToolBlockBreaking.get()).booleanValue()) {
                this.m_6074_();
                if (!player.m_7500_()) {
                    player.m_21205_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                }
            } else if (item == SCContent.DISGUISE_MODULE.get()) {
                ItemStack module = this.getDisguiseModule();
                if (!module.m_41619_()) {
                    Block.m_49840_((Level)this.m_9236_(), (BlockPos)pos, (ItemStack)module);
                }
                this.addDisguiseModule(player.m_21205_());
                if (!player.m_7500_()) {
                    player.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                }
            } else if (item == SCContent.ALLOWLIST_MODULE.get()) {
                ItemStack module = this.getAllowlistModule();
                if (!module.m_41619_()) {
                    Block.m_49840_((Level)this.m_9236_(), (BlockPos)pos, (ItemStack)module);
                }
                this.setAllowlistModule(player.m_21205_());
                if (!player.m_7500_()) {
                    player.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                }
            } else if (item == SCContent.SPEED_MODULE.get()) {
                if (!this.hasSpeedModule()) {
                    this.setHasSpeedModule(true);
                    if (!player.m_7500_()) {
                        player.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    }
                }
            } else if (item == SCContent.UNIVERSAL_BLOCK_MODIFIER.get()) {
                Block.m_49840_((Level)this.m_9236_(), (BlockPos)pos, (ItemStack)this.getDisguiseModule());
                Block.m_49840_((Level)this.m_9236_(), (BlockPos)pos, (ItemStack)this.getAllowlistModule());
                if (this.hasSpeedModule()) {
                    Block.m_49840_((Level)this.m_9236_(), (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)SCContent.SPEED_MODULE.get()));
                }
                this.getSentryDisguiseBlockEntity().ifPresent(be -> be.removeModule(ModuleType.DISGUISE, false));
                this.m_9236_().m_46597_(this.m_20183_(), (BlockState)this.m_9236_().m_8055_(this.m_20183_()).m_61124_((Property)SometimesVisibleBlock.INVISIBLE, (Comparable)Boolean.valueOf(true)));
                this.f_19804_.m_135381_(ALLOWLIST, (Object)new CompoundTag());
                this.f_19804_.m_135381_(HAS_SPEED_MODULE, (Object)false);
            } else if (item == SCContent.SENTRY_REMOTE_ACCESS_TOOL.get()) {
                item.m_6225_(new UseOnContext(player, hand, new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.NORTH, pos, false)));
            } else if (item == SCContent.UNIVERSAL_OWNER_CHANGER.get()) {
                String newOwner;
                this.f_19804_.m_135381_(OWNER, (Object)new Owner(newOwner, PlayerUtils.isPlayerOnline(newOwner = player.m_21205_().m_41786_().getString()) ? PlayerUtils.getPlayerFromName(newOwner).m_20148_().toString() : "ownerUUID"));
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), ChatFormatting.GREEN);
            } else {
                this.toggleMode(player);
            }
            player.m_6674_(InteractionHand.MAIN_HAND);
            return InteractionResult.SUCCESS;
        }
        if (!this.isOwnedBy((Entity)player) && hand == InteractionHand.MAIN_HAND && player.m_7500_() && (player.m_6047_() || player.m_21205_().m_41720_() == SCContent.UNIVERSAL_BLOCK_REMOVER.get())) {
            this.m_6074_();
        }
        return super.m_6071_(player, hand);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        BlockPos pos = this.m_20183_();
        ItemStack sentryStack = new ItemStack((ItemLike)SCContent.SENTRY.get());
        if (this.m_8077_()) {
            sentryStack.m_41714_(this.m_7770_());
        }
        super.m_142687_(reason);
        Block.m_49840_((Level)this.m_9236_(), (BlockPos)pos, (ItemStack)sentryStack);
        Block.m_49840_((Level)this.m_9236_(), (BlockPos)pos, (ItemStack)this.getDisguiseModule());
        Block.m_49840_((Level)this.m_9236_(), (BlockPos)pos, (ItemStack)this.getAllowlistModule());
        this.m_9236_().m_46597_(pos, this.m_9236_().m_6425_(pos).m_76188_());
        if (this.hasSpeedModule()) {
            Block.m_49840_((Level)this.m_9236_(), (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)SCContent.SPEED_MODULE.get()));
        }
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.m_146850_(GameEvent.f_223707_);
    }

    public void toggleMode(Player player) {
        this.toggleMode(player, (Integer)this.f_19804_.m_135370_(MODE) + 1, true);
    }

    public void toggleMode(Player player, int mode, boolean sendMessage) {
        if (mode < 0 || mode >= SentryMode.values().length) {
            mode = 0;
        }
        this.f_19804_.m_135381_(MODE, (Object)mode);
        if (sendMessage) {
            player.m_5661_((Component)Utils.localize(SentryMode.values()[mode].getModeKey(), new Object[0]).m_7220_((Component)Utils.localize(SentryMode.values()[mode].getDescriptionKey(), new Object[0])), true);
        }
    }

    public void m_6710_(LivingEntity target) {
        if (this.isShutDown()) {
            super.m_6710_(null);
            return;
        }
        this.f_19804_.m_135381_(HAS_TARGET, (Object)(target != null ? 1 : 0));
        super.m_6710_(target);
    }

    public boolean hasTarget() {
        return (Boolean)this.f_19804_.m_135370_(HAS_TARGET);
    }

    public float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 1.6f;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        Player player;
        if (target instanceof Player && ((player = (Player)target).m_5833_() || player.m_7500_())) {
            return;
        }
        if (this.m_20280_((Entity)target) > 400.0) {
            return;
        }
        if (this.isShutDown()) {
            return;
        }
        Level level = this.m_9236_();
        BlockEntity blockEntity = level.m_7702_(this.m_20183_().m_7495_());
        Bullet throwableEntity = null;
        SoundEvent shootSound = SoundEvents.f_11687_;
        AbstractProjectileDispenseBehavior pdb = null;
        LazyOptional optional = LazyOptional.empty();
        if (blockEntity instanceof ISentryBulletContainer) {
            ISentryBulletContainer be = (ISentryBulletContainer)blockEntity;
            optional = be.getHandlerForSentry(this);
        } else if (blockEntity != null) {
            optional = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP);
        }
        if (optional.isPresent()) {
            IItemHandler handler = (IItemHandler)optional.orElse(null);
            for (int i = 0; i < handler.getSlots(); ++i) {
                DispenseItemBehavior dispenseBehavior;
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.m_41619_() || !((dispenseBehavior = ((DispenserBlock)Blocks.f_50061_).m_7216_(stack)) instanceof AbstractProjectileDispenseBehavior)) continue;
                AbstractProjectileDispenseBehavior projectileDispenseBehavior = (AbstractProjectileDispenseBehavior)dispenseBehavior;
                ItemStack extracted = handler.extractItem(i, 1, false);
                pdb = projectileDispenseBehavior;
                throwableEntity = pdb.m_6895_(level, (Position)this.m_20182_().m_82520_(0.0, 1.6, 0.0), extracted);
                throwableEntity.m_5602_((Entity)this);
                shootSound = null;
                break;
            }
        }
        if (throwableEntity == null) {
            throwableEntity = new Bullet(level, this);
        }
        double baseY = target.m_20186_() + (double)target.m_20192_() - (double)1.1f;
        double x = target.m_20185_() - this.m_20185_();
        double y = baseY - throwableEntity.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        float yOffset = Mth.m_14116_((float)((float)(x * x + z * z))) * 0.2f;
        this.f_19804_.m_135381_(HEAD_ROTATION, (Object)Float.valueOf((float)(Mth.m_14136_((double)x, (double)(-z)) * 57.29577951308232)));
        throwableEntity.m_6686_(x, y + (double)yOffset, z, 1.6f, 0.0f);
        if (shootSound == null) {
            if (!level.f_46443_ && pdb != null) {
                pdb.m_6823_((BlockSource)new BlockSourceImpl((ServerLevel)level, this.m_20183_()));
            }
        } else {
            this.m_5496_(shootSound, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        }
        level.m_7967_((Entity)throwableEntity);
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128365_("TileEntityData", (Tag)this.getOwnerTag());
        tag.m_128365_("InstalledWhitelist", (Tag)this.getAllowlistModule().m_41739_(new CompoundTag()));
        tag.m_128379_("HasSpeedModule", this.hasSpeedModule());
        tag.m_128405_("SentryMode", ((Integer)this.f_19804_.m_135370_(MODE)).intValue());
        tag.m_128379_("HasTarget", this.hasTarget());
        tag.m_128350_("HeadRotation", ((Float)this.f_19804_.m_135370_(HEAD_ROTATION)).floatValue());
        tag.m_128379_("ShutDown", this.isShutDown());
        super.m_7380_(tag);
    }

    private CompoundTag getOwnerTag() {
        CompoundTag tag = new CompoundTag();
        Owner owner = (Owner)this.f_19804_.m_135370_(OWNER);
        owner.save(tag, this.needsValidation());
        return tag;
    }

    public void m_7378_(CompoundTag tag) {
        CompoundTag teTag = tag.m_128469_("TileEntityData");
        Owner owner = Owner.fromCompound(teTag);
        float savedHeadRotation = tag.m_128457_("HeadRotation");
        this.f_19804_.m_135381_(OWNER, (Object)owner);
        this.getSentryDisguiseBlockEntity().ifPresent(be -> {
            ItemStack module;
            if (tag.m_128441_("InstalledModule") && !(module = ItemStack.m_41712_((CompoundTag)tag.m_128469_("InstalledModule"))).m_41619_() && module.m_41720_() instanceof ModuleItem && ModuleItem.getBlockAddon(module) != null) {
                be.insertModule(module, false);
                this.m_9236_().m_46597_(this.m_20183_(), (BlockState)this.m_9236_().m_8055_(this.m_20183_()).m_61124_((Property)SometimesVisibleBlock.INVISIBLE, (Comparable)Boolean.valueOf(false)));
            }
        });
        this.f_19804_.m_135381_(ALLOWLIST, (Object)tag.m_128469_("InstalledWhitelist"));
        this.f_19804_.m_135381_(HAS_SPEED_MODULE, (Object)tag.m_128471_("HasSpeedModule"));
        this.f_19804_.m_135381_(MODE, (Object)tag.m_128451_("SentryMode"));
        this.f_19804_.m_135381_(HAS_TARGET, (Object)tag.m_128471_("HasTarget"));
        this.f_19804_.m_135381_(SHUT_DOWN, (Object)tag.m_128471_("ShutDown"));
        this.f_19804_.m_135381_(HEAD_ROTATION, (Object)Float.valueOf(savedHeadRotation));
        this.oHeadRotation = savedHeadRotation;
        this.headRotation = savedHeadRotation;
        super.m_7378_(tag);
    }

    public void m_269505_(List<SynchedEntityData.DataValue<?>> dataList) {
        super.m_269505_(dataList);
        if (this.m_9236_().f_46443_ && !this.hasReceivedEntityData) {
            if (this.shouldHeadBeUp()) {
                this.headYTranslation = 0.025f;
            }
            this.hasReceivedEntityData = true;
        }
    }

    private boolean shouldHeadBeUp() {
        return !this.isShutDown() && (this.getMode().isAggressive() || this.getMode().isCamouflage() && this.hasTarget());
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.f_19804_.m_135381_(OWNER, (Object)new Owner(name, uuid));
    }

    @Override
    public Owner getOwner() {
        return (Owner)this.f_19804_.m_135370_(OWNER);
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
    }

    public void addDisguiseModule(ItemStack module) {
        if (ModuleItem.getBlockAddon(module) != null) {
            this.getSentryDisguiseBlockEntity().ifPresent(be -> {
                be.removeModule(ModuleType.DISGUISE, false);
                be.insertModule(module, false);
                this.m_9236_().m_46597_(this.m_20183_(), (BlockState)this.m_9236_().m_8055_(this.m_20183_()).m_61124_((Property)SometimesVisibleBlock.INVISIBLE, (Comparable)Boolean.valueOf(false)));
            });
        }
    }

    public void setAllowlistModule(ItemStack module) {
        this.f_19804_.m_135381_(ALLOWLIST, (Object)module.m_41739_(new CompoundTag()));
    }

    public void setHasSpeedModule(boolean hasSpeedModule) {
        this.f_19804_.m_135381_(HAS_SPEED_MODULE, (Object)hasSpeedModule);
    }

    public ItemStack getDisguiseModule() {
        Optional<DisguisableBlockEntity> be = this.getSentryDisguiseBlockEntity();
        if (be.isPresent()) {
            return be.get().getModule(ModuleType.DISGUISE);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getAllowlistModule() {
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(ALLOWLIST);
        if (tag == null || tag.m_128456_()) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)tag);
    }

    public boolean hasSpeedModule() {
        return (Boolean)this.f_19804_.m_135370_(HAS_SPEED_MODULE);
    }

    public SentryMode getMode() {
        int mode = (Integer)this.f_19804_.m_135370_(MODE);
        return mode < 0 || mode >= SentryMode.values().length ? SentryMode.CAMOUFLAGE_HP : SentryMode.values()[mode];
    }

    public float getHeadYTranslation(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.oHeadYTranslation, (float)this.headYTranslation);
    }

    public Optional<DisguisableBlockEntity> getSentryDisguiseBlockEntity() {
        BlockEntity be;
        Block blockAtSentryPos = this.m_9236_().m_8055_(this.m_20183_()).m_60734_();
        if (blockAtSentryPos != SCContent.SENTRY_DISGUISE.get()) {
            this.m_9236_().m_46597_(this.m_20183_(), (BlockState)((SometimesVisibleBlock)SCContent.SENTRY_DISGUISE.get()).m_49966_().m_61124_((Property)DisguisableBlock.WATERLOGGED, (Comparable)Boolean.valueOf(blockAtSentryPos == Blocks.f_49990_)));
            be = this.m_9236_().m_7702_(this.m_20183_());
            if (be instanceof IOwnable) {
                IOwnable ownable = (IOwnable)be;
                Owner owner = this.getOwner();
                ownable.setOwner(owner.getUUID(), owner.getName());
            }
        } else {
            be = this.m_9236_().m_7702_(this.m_20183_());
        }
        if (be instanceof DisguisableBlockEntity) {
            DisguisableBlockEntity dbe = (DisguisableBlockEntity)be;
            return Optional.of(dbe);
        }
        return Optional.empty();
    }

    public boolean isTargetingAllowedPlayer(LivingEntity potentialTarget) {
        if (potentialTarget != null) {
            ItemStack allowlistModule = this.getAllowlistModule();
            if (allowlistModule.m_41782_() && allowlistModule.m_41783_().m_128471_("affectEveryone")) {
                return true;
            }
            List<String> players = ModuleItem.getPlayersFromModule(allowlistModule);
            for (String s : players) {
                if (!potentialTarget.m_7755_().getString().equalsIgnoreCase(s)) continue;
                return true;
            }
            return ModuleItem.doesModuleHaveTeamOf(allowlistModule, potentialTarget.m_7755_().getString(), this.m_9236_());
        }
        return false;
    }

    public int getShootingSpeed() {
        return this.hasSpeedModule() ? 5 : 10;
    }

    @Override
    public void shutDown() {
        IEMPAffected.super.shutDown();
        this.m_6710_(null);
    }

    @Override
    public boolean isShutDown() {
        return (Boolean)this.f_19804_.m_135370_(SHUT_DOWN);
    }

    @Override
    public void setShutDown(boolean shutDown) {
        this.f_19804_.m_135381_(SHUT_DOWN, (Object)shutDown);
    }

    public boolean m_7327_(Entity entity) {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_5789_() {
        return false;
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType reason) {
        return false;
    }

    public void m_6135_() {
    }

    public boolean m_21691_() {
        return false;
    }

    public void m_6043_() {
    }

    public boolean m_6785_(double distanceClosestToPlayer) {
        return false;
    }

    public void m_6123_(Player entity) {
    }

    public void m_6478_(MoverType type, Vec3 vec) {
    }

    protected void m_7324_(Entity entity) {
    }

    protected void m_6138_() {
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public void m_6119_() {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void setAnimateUpwards(boolean animateUpwards) {
        this.animateUpwards = animateUpwards;
    }

    public boolean animatesUpwards() {
        return this.animateUpwards;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public boolean isAnimating() {
        return this.animate;
    }

    public float getOriginalHeadRotation() {
        return this.oHeadRotation;
    }

    public float getHeadRotation() {
        return this.headRotation;
    }

    public static enum SentryMode {
        CAMOUFLAGE_HP(1, TargetingMode.PLAYERS_AND_MOBS, 1),
        CAMOUFLAGE_H(1, TargetingMode.MOBS, 3),
        CAMOUFLAGE_P(1, TargetingMode.PLAYERS, 5),
        AGGRESSIVE_HP(0, TargetingMode.PLAYERS_AND_MOBS, 0),
        AGGRESSIVE_H(0, TargetingMode.MOBS, 2),
        AGGRESSIVE_P(0, TargetingMode.PLAYERS, 4),
        IDLE(-1, null, 6);

        private final int type;
        private final TargetingMode targetingMode;
        private final int descriptionKeyIndex;

        private SentryMode(int type, TargetingMode targetingMode, int descriptionKeyIndex) {
            this.type = type;
            this.targetingMode = targetingMode;
            this.descriptionKeyIndex = descriptionKeyIndex;
        }

        public boolean isAggressive() {
            return this.type == 0;
        }

        public boolean isCamouflage() {
            return this.type == 1;
        }

        public boolean attacksHostile() {
            return this.targetingMode != null && this.targetingMode.allowsMobs();
        }

        public boolean attacksPlayers() {
            return this.targetingMode != null && this.targetingMode.allowsPlayers();
        }

        public String getModeKey() {
            String key = "messages.securitycraft:sentry.mode";
            return this.isAggressive() ? key + "0" : (this.isCamouflage() ? key + "1" : key + "2");
        }

        public String getTargetKey() {
            String key = "gui.securitycraft:srat.targets";
            return switch (this.targetingMode) {
                case TargetingMode.PLAYERS_AND_MOBS -> key + "1";
                case TargetingMode.MOBS -> key + "2";
                case TargetingMode.PLAYERS -> key + "3";
                default -> "";
            };
        }

        public String getDescriptionKey() {
            return "messages.securitycraft:sentry.descriptionMode" + this.descriptionKeyIndex;
        }
    }
}

