/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import java.util.function.Consumer;
import net.geforcemods.securitycraft.entity.camera.CameraClientChunkCacheExtension;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.IChunkStorageProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientChunkCache.class}, priority=1100)
public abstract class ClientChunkCacheMixin
implements IChunkStorageProvider {
    @Shadow
    volatile ClientChunkCache.Storage f_104410_;
    @Shadow
    @Final
    ClientLevel f_104411_;

    @Inject(method={"drop"}, at={@At(value="HEAD")})
    private void securitycraft$onDrop(int x, int z, CallbackInfo ci) {
        ChunkPos pos = new ChunkPos(x, z);
        int renderDistance = (Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_();
        Entity cameraEntity = Minecraft.m_91087_().f_91075_;
        if (cameraEntity instanceof SecurityCamera && pos.m_45594_(cameraEntity.m_146902_()) <= renderDistance + 1 || FrameFeedHandler.shouldAddChunk(pos, renderDistance)) {
            return;
        }
        CameraClientChunkCacheExtension.drop(this.f_104411_, pos);
    }

    @Inject(method={"replaceWithPacketData"}, at={@At(value="HEAD")}, cancellable=true)
    private void securitycraft$onReplaceChunk(int x, int z, FriendlyByteBuf buffer, CompoundTag chunkTag, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> tagOutputConsumer, CallbackInfoReturnable<LevelChunk> cir) {
        int renderDistance = (Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_();
        Entity cameraEntity = Minecraft.m_91087_().f_91075_;
        ChunkPos pos = new ChunkPos(x, z);
        boolean isInPlayerRange = this.f_104410_.m_104500_(x, z);
        boolean shouldAddChunk = false;
        shouldAddChunk = cameraEntity instanceof SecurityCamera && pos.m_45594_(cameraEntity.m_146902_()) <= renderDistance + 1 ? true : FrameFeedHandler.shouldAddChunk(pos, renderDistance);
        if (shouldAddChunk) {
            LevelChunk newChunk = CameraClientChunkCacheExtension.replaceWithPacketData(this.f_104411_, x, z, new FriendlyByteBuf(buffer.copy()), chunkTag, tagOutputConsumer);
            if (!isInPlayerRange) {
                cir.setReturnValue((Object)newChunk);
            }
        }
    }

    @Inject(method={"getChunk(IILnet/minecraft/world/level/chunk/ChunkStatus;Z)Lnet/minecraft/world/level/chunk/LevelChunk;"}, at={@At(value="TAIL")}, cancellable=true)
    private void securitycraft$onGetChunk(int x, int z, ChunkStatus requiredStatus, boolean requireChunk, CallbackInfoReturnable<LevelChunk> cir) {
        LevelChunk chunk;
        if (!this.f_104410_.m_104500_(x, z) && (chunk = CameraClientChunkCacheExtension.getChunk(x, z)) != null) {
            cir.setReturnValue((Object)chunk);
        }
    }
}

