/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.FontHelper;

@OnlyIn(value=Dist.CLIENT)
public class ScreenReadableScroll
extends TBScreen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tombstone", "textures/gui/scroll.png");
    private static final ResourceLocation ARROW_UP = new ResourceLocation("tombstone", "textures/gui/arrow-up.png");
    private static final ResourceLocation ARROW_DOWN = new ResourceLocation("tombstone", "textures/gui/arrow-down.png");
    private static final Pattern TAG_PATTERN = Pattern.compile("\\[(/?)(b|i|c(?:=#[0-9a-fA-F]{6})?)\\]");
    private static final int VISIBLE_LINES = 15;
    private final List<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
    private int scrollOffset = 0;
    private final int textWidth = 180;

    public ScreenReadableScroll(String contentId, int contentPart) {
        super((Component)Component.m_237113_((String)"Readable Scroll"), 380, 250);
        this.initScroll(contentId + "_" + contentPart);
    }

    @Override
    protected ResourceLocation getBackground() {
        return BACKGROUND;
    }

    @Override
    protected boolean hasWhiteBorder() {
        return false;
    }

    private void initScroll(String fileName) {
        CompletableFuture.runAsync(() -> {
            Minecraft mc = Minecraft.m_91087_();
            String langCode = mc.f_91066_.f_92075_;
            String prefix = "/assets/tombstone/text/" + fileName + "_";
            InputStream input = null;
            if (!"en_us".equals(langCode) && (input = ModTombstone.class.getResourceAsStream(prefix + langCode + ".txt")) == null && langCode.contains("_")) {
                String baseLang = langCode.split("_")[0];
                input = ModTombstone.class.getResourceAsStream(prefix + baseLang + "_" + baseLang + ".txt");
            }
            if (input == null) {
                input = ModTombstone.class.getResourceAsStream(prefix + "en_us.txt");
            }
            if (input == null) {
                mc.execute(() -> ModTombstone.LOGGER.error("File not found: {}_en_us.txt", (Object)fileName));
                return;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                String line;
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line).append("\n");
                }
                mc.execute(() -> this.lines.addAll(mc.f_91062_.m_92923_((FormattedText)FontHelper.withFantasyFont(this.parse(stringBuilder.toString())), 180)));
            }
            catch (IOException e) {
                mc.execute(() -> ModTombstone.LOGGER.error("Unable to read scroll: '{}'", (Object)fileName, (Object)e));
            }
        });
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            this.scrollOffset = Math.min(this.scrollOffset + 1, Math.max(0, this.lines.size() - 15));
        } else if (delta > 0.0) {
            this.scrollOffset = Math.max(this.scrollOffset - 1, 0);
        }
        return true;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isResized) {
            return;
        }
        this.m_280273_(guiGraphics);
        if (this.scrollOffset > 0) {
            guiGraphics.m_280163_(ARROW_UP, this.f_96543_ / 2 - 5, this.guiTop + 50, 0.0f, 0.0f, 10, 7, 10, 7);
        }
        int x = this.guiLeft + 95;
        int y = this.guiTop + 60;
        for (int i = 0; i < 15 && i + this.scrollOffset < this.lines.size(); ++i) {
            FormattedCharSequence line = this.lines.get(i + this.scrollOffset);
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280649_(this.f_96547_, line, x, y + i * 9, -1875, true);
        }
        if (this.scrollOffset < this.lines.size() - 15) {
            guiGraphics.m_280163_(ARROW_DOWN, this.f_96543_ / 2 - 5, this.guiTop + 200, 0.0f, 0.0f, 10, 7, 10, 7);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public Component parse(String input) {
        MutableComponent result = Component.m_237119_();
        Stack<Style> styles = new Stack<Style>();
        styles.push(Style.f_131099_);
        Matcher matcher = TAG_PATTERN.matcher(input);
        int lastIndex = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String preText = input.substring(lastIndex, start);
            if (!preText.isEmpty()) {
                result.m_7220_((Component)Component.m_237113_((String)preText).m_6270_((Style)styles.peek()));
            }
            String isClosing = matcher.group(1);
            String tag = matcher.group(2);
            if (isClosing.isEmpty()) {
                Style updated = (Style)styles.peek();
                if ("b".equals(tag)) {
                    updated = updated.m_131136_(Boolean.valueOf(true));
                } else if ("i".equals(tag)) {
                    updated = updated.m_131155_(Boolean.valueOf(true));
                } else if (tag.startsWith("c=#")) {
                    String hex = tag.substring(tag.indexOf(35));
                    TextColor color = TextColor.m_131268_((String)hex);
                    updated = updated.m_131148_(color);
                }
                styles.push(updated);
            } else if (styles.size() > 1) {
                styles.pop();
            } else {
                ModTombstone.LOGGER.error("Excessive tag closure : " + tag);
            }
            lastIndex = end;
        }
        if (lastIndex < input.length()) {
            result.m_7220_((Component)Component.m_237113_((String)input.substring(lastIndex)).m_6270_((Style)styles.peek()));
        }
        return result;
    }
}

