/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.capability.ProtectedEntityProvider;
import ovh.corail.tombstone.helper.Helper;

public record CMessagePlayerProtection(boolean active) {
    static CMessagePlayerProtection fromBytes(FriendlyByteBuf buf) {
        return new CMessagePlayerProtection(buf.readBoolean());
    }

    static void toBytes(CMessagePlayerProtection msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.active);
    }

    public static class Handler {
        static void handle(final CMessagePlayerProtection msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        Player player = ModTombstone.PROXY.getClientPlayer();
                        if (player != null) {
                            player.getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).ifPresent(cap -> cap.apply((LivingEntity)player, msg2.active));
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

