/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.animation;

import de.markusbordihn.easynpc.data.model.ModelArmPose;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;

public interface HumanoidArmPoseAnimation {
    public static <T extends Mob> void animateHumanoidModelArmPoseAttackingWithMeleeWeapon(ModelPart rightArmPart, ModelPart leftArmPart, T mob, float attackTime, float ageInTicks) {
        AnimationUtils.m_102091_((ModelPart)rightArmPart, (ModelPart)leftArmPart, mob, (float)attackTime, (float)ageInTicks);
    }

    public static <T extends Mob> void animateHumanoidModelArmPoseAttacking(ModelPart rightArmPart, ModelPart leftArmPart, T mob, float attackTime, float ageInTicks) {
        AnimationUtils.m_102091_((ModelPart)rightArmPart, (ModelPart)leftArmPart, mob, (float)attackTime, (float)ageInTicks);
    }

    public static void animateHumanoidModelArmPoseBowAndArrow(ModelPart rightArmPart, ModelPart leftArmPart, ModelPart headModelPart) {
        rightArmPart.f_104204_ = -0.1f + headModelPart.f_104204_;
        rightArmPart.f_104203_ = -1.5707964f + headModelPart.f_104203_;
        leftArmPart.f_104203_ = -0.9424779f + headModelPart.f_104203_;
        leftArmPart.f_104204_ = headModelPart.f_104204_ - 0.4f;
        leftArmPart.f_104205_ = 1.5707964f;
    }

    public static void animateHumanoidModelArmPoseCelebrating(ModelPart rightArmPart, ModelPart leftArmPart, float ageInTicks) {
        rightArmPart.f_104202_ = 0.0f;
        rightArmPart.f_104200_ = -5.0f;
        rightArmPart.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
        rightArmPart.f_104205_ = 2.670354f;
        rightArmPart.f_104204_ = 0.0f;
        leftArmPart.f_104202_ = 0.0f;
        leftArmPart.f_104200_ = 5.0f;
        leftArmPart.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
        leftArmPart.f_104205_ = -2.3561945f;
        leftArmPart.f_104204_ = 0.0f;
    }

    public static <T extends Mob> void animateHumanoidModelArmPoseCrossbowCharge(ModelPart rightArmPart, ModelPart leftArmPart, T mob) {
        AnimationUtils.m_102086_((ModelPart)rightArmPart, (ModelPart)leftArmPart, mob, (boolean)true);
    }

    public static void animateHumanoidModelArmPoseCrossbowHold(ModelPart rightArmPart, ModelPart leftArmPart, ModelPart headModelPart) {
        AnimationUtils.m_102097_((ModelPart)rightArmPart, (ModelPart)leftArmPart, (ModelPart)headModelPart, (boolean)true);
    }

    public static void animateHumanoidModelArmPoseGunHold(ModelPart rightArmPart, ModelPart leftArmPart, ModelPart headModelPart) {
        rightArmPart.f_104204_ = -0.1f + headModelPart.f_104204_;
        rightArmPart.f_104203_ = -1.5707964f + headModelPart.f_104203_ + 0.3f;
        leftArmPart.f_104204_ = 0.1f + headModelPart.f_104204_;
        leftArmPart.f_104203_ = -1.5707964f + headModelPart.f_104203_ + 1.5f;
    }

    public static void animateHumanoidModelArmPoseDancing(ModelPart headModelPart, ModelPart bodyPart, ModelPart rightArmPart, ModelPart leftArmPart, float ageInTicks) {
        float swingAmount = ageInTicks / 60.0f;
        headModelPart.f_104200_ = Mth.m_14031_((float)(swingAmount * 10.0f));
        headModelPart.f_104201_ = Mth.m_14031_((float)(swingAmount * 40.0f)) + 0.4f;
        rightArmPart.f_104205_ = (float)Math.PI / 180 * (70.0f + Mth.m_14089_((float)(swingAmount * 40.0f)) * 10.0f);
        leftArmPart.f_104205_ = rightArmPart.f_104205_ * -1.0f;
        rightArmPart.f_104201_ = Mth.m_14031_((float)(swingAmount * 40.0f)) * 0.5f + 1.5f;
        leftArmPart.f_104201_ = Mth.m_14031_((float)(swingAmount * 40.0f)) * 0.5f + 1.5f;
        bodyPart.f_104201_ = Mth.m_14031_((float)(swingAmount * 40.0f)) * 0.35f;
    }

    public static void animateHumanoidModelArmPoseSpellcasting(ModelPart rightArmPart, ModelPart leftArmPart, float ageInTicks) {
        rightArmPart.f_104202_ = 0.0f;
        rightArmPart.f_104200_ = -5.0f;
        leftArmPart.f_104202_ = 0.0f;
        leftArmPart.f_104200_ = 5.0f;
        rightArmPart.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
        leftArmPart.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
        rightArmPart.f_104205_ = 2.3561945f;
        leftArmPart.f_104205_ = -2.3561945f;
        rightArmPart.f_104204_ = 0.0f;
        leftArmPart.f_104204_ = 0.0f;
    }

    public static void animateHumanoidModelArmPoseSpyglass(ModelPart rightArmPart, ModelPart leftArmPart, float ageInTicks) {
        AnimationUtils.m_170341_((ModelPart)rightArmPart, (float)ageInTicks, (float)1.0f);
    }

    public static boolean animateHumanoidArmPose(Mob mob, ModelArmPose modelArmPose, ModelPart headModelPart, ModelPart bodyPart, ModelPart rightArmPart, ModelPart leftArmPart, float attackTime, float ageInTicks) {
        switch (modelArmPose) {
            case ATTACKING: {
                HumanoidArmPoseAnimation.animateHumanoidModelArmPoseAttacking(rightArmPart, leftArmPart, mob, attackTime, ageInTicks);
                break;
            }
            case ATTACKING_WITH_MELEE_WEAPON: {
                HumanoidArmPoseAnimation.animateHumanoidModelArmPoseAttackingWithMeleeWeapon(rightArmPart, leftArmPart, mob, attackTime, ageInTicks);
                break;
            }
            case BOW_AND_ARROW: {
                HumanoidArmPoseAnimation.animateHumanoidModelArmPoseBowAndArrow(rightArmPart, leftArmPart, headModelPart);
                break;
            }
            case CELEBRATING: {
                HumanoidArmPoseAnimation.animateHumanoidModelArmPoseCelebrating(rightArmPart, leftArmPart, ageInTicks);
                break;
            }
            case CROSSBOW_CHARGE: {
                HumanoidArmPoseAnimation.animateHumanoidModelArmPoseCrossbowCharge(rightArmPart, leftArmPart, mob);
                break;
            }
            case CROSSBOW_HOLD: {
                HumanoidArmPoseAnimation.animateHumanoidModelArmPoseCrossbowHold(rightArmPart, leftArmPart, headModelPart);
                break;
            }
            case DANCING: {
                HumanoidArmPoseAnimation.animateHumanoidModelArmPoseDancing(headModelPart, bodyPart, rightArmPart, leftArmPart, ageInTicks);
                break;
            }
            case GUN_HOLD: {
                HumanoidArmPoseAnimation.animateHumanoidModelArmPoseGunHold(rightArmPart, leftArmPart, headModelPart);
                break;
            }
            case SPELLCASTING: {
                HumanoidArmPoseAnimation.animateHumanoidModelArmPoseSpellcasting(rightArmPart, leftArmPart, ageInTicks);
                break;
            }
            case SPYGLASS: {
                HumanoidArmPoseAnimation.animateHumanoidModelArmPoseSpyglass(rightArmPart, leftArmPart, ageInTicks);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

