/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.standard.StandardSkeletonModel;
import de.markusbordihn.easynpc.client.renderer.EasyNPCModelRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseHumanoidMobModelRenderer;
import de.markusbordihn.easynpc.entity.easynpc.npc.Skeleton;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class SkeletonModelRenderer
extends BaseHumanoidMobModelRenderer<Skeleton, Skeleton.Variant, StandardSkeletonModel<Skeleton>> {
    protected static final Map<Skeleton.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(Skeleton.Variant.class), map -> {
        map.put(Skeleton.Variant.SKELETON, new ResourceLocation("textures/entity/skeleton/skeleton.png"));
        map.put(Skeleton.Variant.STRAY, new ResourceLocation("textures/entity/skeleton/stray.png"));
        map.put(Skeleton.Variant.WITHER_SKELETON, new ResourceLocation("textures/entity/skeleton/wither_skeleton.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)Skeleton.Variant.SKELETON);

    public <L extends RenderLayer<Skeleton, StandardSkeletonModel<Skeleton>>> SkeletonModelRenderer(EntityRendererProvider.Context context, Class<L> humanoidArmorLayerClass) {
        super(context, new StandardSkeletonModel(context.m_174023_(ModelLayers.f_171236_)), 0.5f, DEFAULT_TEXTURE, TEXTURE_BY_VARIANT);
        this.m_115326_((RenderLayer)EasyNPCModelRenderer.getHumanoidArmorLayer(this, context, ModelLayers.f_171238_, ModelLayers.f_171239_, humanoidArmorLayerClass));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.m_174027_()));
    }

    @Override
    public void renderDefaultPose(Skeleton entity, StandardSkeletonModel<Skeleton> model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (pose) {
            case DYING: {
                poseStack.m_85837_(-1.0, 0.0, 0.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(this.m_6441_((LivingEntity)entity)));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                model.m_5585_().f_104203_ = -0.7853982f;
                model.m_5585_().f_104204_ = -0.7853982f;
                model.m_5585_().f_104205_ = -0.7853982f;
                break;
            }
            case LONG_JUMPING: {
                model.f_102815_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                model.f_102816_ = HumanoidModel.ArmPose.SPYGLASS;
                break;
            }
            case SLEEPING: {
                poseStack.m_85837_(1.0, 0.0, 0.0);
                break;
            }
            case SPIN_ATTACK: {
                model.f_102815_ = HumanoidModel.ArmPose.BLOCK;
                model.f_102816_ = HumanoidModel.ArmPose.THROW_SPEAR;
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-35.0f));
                break;
            }
            default: {
                model.f_102815_ = HumanoidModel.ArmPose.EMPTY;
                model.f_102816_ = HumanoidModel.ArmPose.EMPTY;
                model.m_5585_().f_104203_ = 0.0f;
                model.m_5585_().f_104204_ = 0.0f;
                model.m_5585_().f_104205_ = 0.0f;
            }
        }
    }
}

