/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.objective;

import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.data.objective.ObjectiveUtils;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.Locale;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public final class ObjectiveDataEntry {
    public static final String DATA_ATTACK_INTERVAL_TAG = "AttackInterval";
    public static final String DATA_ATTACK_RADIUS_TAG = "AttackRadius";
    public static final String DATA_CAN_DEAL_WITH_DOORS_TAG = "CanDealWithDoors";
    public static final String DATA_DISTANCE_TO_POI_TAG = "DistanceToPoi";
    public static final String DATA_ID_TAG = "Id";
    public static final String DATA_INTERVAL_TAG = "Interval";
    public static final String DATA_LOOK_DISTANCE_TAG = "LookDistance";
    public static final String DATA_MUST_REACH_TARGET_TAG = "MustReachTarget";
    public static final String DATA_MUST_SEE_TARGET_TAG = "MustSeeTarget";
    public static final String DATA_ONLY_AT_NIGHT_TAG = "OnlyAtNight";
    public static final String DATA_PRIORITY_TAG = "Prio";
    public static final String DATA_PROBABILITY_TAG = "Probability";
    public static final String DATA_SPEED_MODIFIER_TAG = "SpeedModifier";
    public static final String DATA_START_DISTANCE_TAG = "StartDistance";
    public static final String DATA_STOP_DISTANCE_TAG = "StopDistance";
    public static final String DATA_TARGET_ENTITY_UUID_TAG = "TargetEntityUUID";
    public static final String DATA_TARGET_OWNER_UUID_TAG = "TargetOwnerUUID";
    public static final String DATA_TARGET_PLAYER_NAME_TAG = "TargetPlayerName";
    public static final String DATA_TYPE_TAG = "Type";
    private int attackInterval = 20;
    private float attackRadius = 8.0f;
    private BooleanSupplier canDealWithDoors = () -> false;
    private int distanceToPoi = 16;
    private Goal goal = null;
    private String id = UUID.randomUUID().toString();
    private int interval = 10;
    private boolean isRegistered = false;
    private float lookDistance = 15.0f;
    private boolean mustReachTarget = true;
    private boolean mustSeeTarget = true;
    private ObjectiveType objectiveType = ObjectiveType.NONE;
    private boolean onlyAtNight = false;
    private int priority = 1;
    private float probability = 1.0f;
    private double speedModifier = 0.7;
    private float startDistance = 16.0f;
    private float stopDistance = 2.0f;
    private Goal target = null;
    private UUID targetEntityUUID;
    private UUID targetOwnerUUID;
    private String targetPlayerName;

    public ObjectiveDataEntry() {
    }

    public ObjectiveDataEntry(ObjectiveType objectiveType) {
        this.id = objectiveType.name();
        this.objectiveType = objectiveType;
    }

    public ObjectiveDataEntry(ObjectiveType objectiveType, int priority) {
        this(objectiveType);
        this.priority = priority;
    }

    public ObjectiveDataEntry(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public ObjectiveType getType() {
        return this.objectiveType;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public double getSpeedModifier() {
        return this.speedModifier;
    }

    public void setSpeedModifier(double speedModifier) {
        this.speedModifier = speedModifier;
    }

    public float getStartDistance() {
        return this.startDistance;
    }

    public float getStopDistance() {
        return this.stopDistance;
    }

    public float getProbability() {
        return this.probability;
    }

    public int getDistanceToPoi() {
        return this.distanceToPoi;
    }

    public BooleanSupplier getCanDealWithDoors() {
        return this.canDealWithDoors;
    }

    public boolean getOnlyAtNight() {
        return this.onlyAtNight;
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean isMustSeeTarget() {
        return this.mustSeeTarget;
    }

    public boolean isMustReachTarget() {
        return this.mustReachTarget;
    }

    public String getId() {
        return this.id;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    public String getTargetPlayerName() {
        return this.targetPlayerName;
    }

    public void setTargetPlayerName(String targetPlayerName) {
        this.targetPlayerName = targetPlayerName;
    }

    public float getLookDistance() {
        return this.lookDistance;
    }

    public float getAttackRadius() {
        return this.attackRadius;
    }

    public int getAttackInterval() {
        return this.attackInterval;
    }

    public ServerPlayer getTargetPlayer() {
        if (this.hasPlayerTarget()) {
            return LivingEntityManager.getPlayerByName(this.targetPlayerName);
        }
        return null;
    }

    public UUID getTargetOwnerUUID() {
        return this.targetOwnerUUID;
    }

    public void setTargetOwnerUUID(UUID targetOwnerUUID) {
        this.targetOwnerUUID = targetOwnerUUID;
    }

    public UUID getTargetEntityUUID() {
        return this.targetEntityUUID;
    }

    public void setTargetEntityUUID(UUID targetEntityUUID) {
        this.targetEntityUUID = targetEntityUUID;
    }

    public LivingEntity getTargetEntity(EasyNPC<?> easyNPC) {
        return this.getTargetEntity(easyNPC.getServerLevel());
    }

    public LivingEntity getTargetEntity(ServerLevel serverLevel) {
        if (this.hasEntityTarget() && serverLevel != null) {
            return LivingEntityManager.getLivingEntityByUUID(this.targetEntityUUID, serverLevel);
        }
        return null;
    }

    public Entity getTargetOwner(EasyNPC<?> easyNPC) {
        return this.getTargetOwner(easyNPC.getServerLevel());
    }

    public Entity getTargetOwner(ServerLevel serverLevel) {
        if (this.hasOwnerTarget() && this.targetOwnerUUID != null && serverLevel != null) {
            return LivingEntityManager.getPlayerByUUID(this.targetOwnerUUID, serverLevel);
        }
        return null;
    }

    public boolean hasTravelObjective() {
        return this.objectiveType.hasTravelObjective();
    }

    public boolean hasOwnerTarget() {
        return this.getType() == ObjectiveType.FOLLOW_OWNER && this.targetOwnerUUID != null;
    }

    public boolean hasPlayerTarget() {
        return this.getType() == ObjectiveType.FOLLOW_PLAYER && this.targetPlayerName != null && !this.targetPlayerName.isEmpty();
    }

    public boolean hasEntityTarget() {
        return this.getType() == ObjectiveType.FOLLOW_ENTITY_BY_UUID && this.targetEntityUUID != null;
    }

    public boolean hasValidTarget(EasyNPC<?> easyNPC) {
        ServerLevel serverLevel = easyNPC.getServerLevel();
        return serverLevel != null && this.hasValidTarget(serverLevel);
    }

    public boolean hasValidTarget(ServerLevel serverLevel) {
        if (!(this.hasOwnerTarget() || this.hasPlayerTarget() || this.hasEntityTarget())) {
            return true;
        }
        if (this.hasOwnerTarget()) {
            ServerPlayer serverPlayer = LivingEntityManager.getPlayerByUUID(this.targetOwnerUUID, serverLevel);
            return serverPlayer != null && serverPlayer.m_6084_();
        }
        if (this.hasPlayerTarget()) {
            ServerPlayer serverPlayer = LivingEntityManager.getPlayerByName(this.targetPlayerName);
            return serverPlayer != null && serverPlayer.m_6084_();
        }
        if (this.hasEntityTarget()) {
            LivingEntity livingEntity = LivingEntityManager.getLivingEntityByUUID(this.targetEntityUUID, serverLevel);
            return livingEntity != null && livingEntity.m_6084_();
        }
        return this.goal != null;
    }

    public Goal getGoal(EasyNPC<?> easyNPC) {
        if (this.goal == null) {
            this.goal = ObjectiveUtils.createObjectiveGoal(this, easyNPC);
        }
        return this.goal;
    }

    public Goal getTarget(EasyNPC<?> easyNPC) {
        if (this.target == null) {
            this.target = ObjectiveUtils.createObjectiveTarget(this, easyNPC);
        }
        return this.target;
    }

    public void load(CompoundTag compoundTag) {
        this.objectiveType = ObjectiveType.get(compoundTag.m_128461_(DATA_TYPE_TAG));
        this.priority = compoundTag.m_128451_(DATA_PRIORITY_TAG);
        this.id = compoundTag.m_128441_(DATA_ID_TAG) && !compoundTag.m_128461_(DATA_ID_TAG).isEmpty() ? compoundTag.m_128461_(DATA_ID_TAG) : this.objectiveType.name();
        if (compoundTag.m_128441_(DATA_TARGET_ENTITY_UUID_TAG)) {
            this.targetEntityUUID = compoundTag.m_128342_(DATA_TARGET_ENTITY_UUID_TAG);
        }
        if (compoundTag.m_128441_(DATA_TARGET_PLAYER_NAME_TAG)) {
            this.targetPlayerName = compoundTag.m_128461_(DATA_TARGET_PLAYER_NAME_TAG);
        }
        if (compoundTag.m_128441_(DATA_TARGET_OWNER_UUID_TAG)) {
            this.targetOwnerUUID = compoundTag.m_128342_(DATA_TARGET_OWNER_UUID_TAG);
        }
        if (compoundTag.m_128441_(DATA_SPEED_MODIFIER_TAG)) {
            this.speedModifier = compoundTag.m_128459_(DATA_SPEED_MODIFIER_TAG);
        }
        if (compoundTag.m_128441_(DATA_START_DISTANCE_TAG)) {
            this.startDistance = compoundTag.m_128457_(DATA_START_DISTANCE_TAG);
        }
        if (compoundTag.m_128441_(DATA_STOP_DISTANCE_TAG)) {
            this.stopDistance = compoundTag.m_128457_(DATA_STOP_DISTANCE_TAG);
        }
        if (compoundTag.m_128441_(DATA_ONLY_AT_NIGHT_TAG)) {
            this.onlyAtNight = compoundTag.m_128471_(DATA_ONLY_AT_NIGHT_TAG);
        }
        if (compoundTag.m_128441_(DATA_DISTANCE_TO_POI_TAG)) {
            this.distanceToPoi = compoundTag.m_128451_(DATA_DISTANCE_TO_POI_TAG);
        }
        if (compoundTag.m_128441_(DATA_CAN_DEAL_WITH_DOORS_TAG)) {
            this.canDealWithDoors = () -> compoundTag.m_128471_(DATA_CAN_DEAL_WITH_DOORS_TAG);
        }
        if (compoundTag.m_128441_(DATA_LOOK_DISTANCE_TAG)) {
            this.lookDistance = compoundTag.m_128457_(DATA_LOOK_DISTANCE_TAG);
        }
        if (compoundTag.m_128441_(DATA_ATTACK_INTERVAL_TAG)) {
            this.attackInterval = compoundTag.m_128451_(DATA_ATTACK_INTERVAL_TAG);
        }
        if (compoundTag.m_128441_(DATA_ATTACK_RADIUS_TAG)) {
            this.attackRadius = compoundTag.m_128457_(DATA_ATTACK_RADIUS_TAG);
        }
        if (compoundTag.m_128441_(DATA_INTERVAL_TAG)) {
            this.interval = compoundTag.m_128451_(DATA_INTERVAL_TAG);
        }
        if (compoundTag.m_128441_(DATA_MUST_SEE_TARGET_TAG)) {
            this.mustSeeTarget = compoundTag.m_128471_(DATA_MUST_SEE_TARGET_TAG);
        }
        if (compoundTag.m_128441_(DATA_MUST_REACH_TARGET_TAG)) {
            this.mustReachTarget = compoundTag.m_128471_(DATA_MUST_REACH_TARGET_TAG);
        }
        if (compoundTag.m_128441_(DATA_PROBABILITY_TAG)) {
            this.probability = compoundTag.m_128457_(DATA_PROBABILITY_TAG);
        }
    }

    public CompoundTag save(CompoundTag compoundTag) {
        compoundTag.m_128359_(DATA_TYPE_TAG, this.objectiveType.name());
        compoundTag.m_128405_(DATA_PRIORITY_TAG, this.priority);
        if (!(this.id == null || this.id.isEmpty() || this.id.equals(this.objectiveType.name()) || this.id.toUpperCase(Locale.ROOT).equals(this.objectiveType.name()))) {
            compoundTag.m_128359_(DATA_ID_TAG, this.id);
        }
        if (this.targetEntityUUID != null) {
            compoundTag.m_128362_(DATA_TARGET_ENTITY_UUID_TAG, this.targetEntityUUID);
        }
        if (this.targetPlayerName != null && !this.targetPlayerName.isEmpty()) {
            compoundTag.m_128359_(DATA_TARGET_PLAYER_NAME_TAG, this.targetPlayerName);
        }
        if (this.targetOwnerUUID != null) {
            compoundTag.m_128362_(DATA_TARGET_OWNER_UUID_TAG, this.targetOwnerUUID);
        }
        if (this.speedModifier != 0.7) {
            compoundTag.m_128347_(DATA_SPEED_MODIFIER_TAG, this.speedModifier);
        }
        if (this.startDistance != 16.0f) {
            compoundTag.m_128350_(DATA_START_DISTANCE_TAG, this.startDistance);
        }
        if (this.stopDistance != 2.0f) {
            compoundTag.m_128350_(DATA_STOP_DISTANCE_TAG, this.stopDistance);
        }
        if (this.onlyAtNight) {
            compoundTag.m_128379_(DATA_ONLY_AT_NIGHT_TAG, true);
        }
        if (this.distanceToPoi != 16) {
            compoundTag.m_128405_(DATA_DISTANCE_TO_POI_TAG, this.distanceToPoi);
        }
        if (this.canDealWithDoors.getAsBoolean()) {
            compoundTag.m_128379_(DATA_CAN_DEAL_WITH_DOORS_TAG, this.canDealWithDoors.getAsBoolean());
        }
        if (this.lookDistance != 15.0f) {
            compoundTag.m_128350_(DATA_LOOK_DISTANCE_TAG, this.lookDistance);
        }
        if (this.attackInterval != 20) {
            compoundTag.m_128405_(DATA_ATTACK_INTERVAL_TAG, this.attackInterval);
        }
        if (this.attackRadius != 8.0f) {
            compoundTag.m_128350_(DATA_ATTACK_RADIUS_TAG, this.attackRadius);
        }
        if (this.interval != 10) {
            compoundTag.m_128405_(DATA_INTERVAL_TAG, this.interval);
        }
        if (!this.mustSeeTarget) {
            compoundTag.m_128379_(DATA_MUST_SEE_TARGET_TAG, false);
        }
        if (!this.mustReachTarget) {
            compoundTag.m_128379_(DATA_MUST_REACH_TARGET_TAG, false);
        }
        if (this.probability != 1.0f) {
            compoundTag.m_128350_(DATA_PROBABILITY_TAG, this.probability);
        }
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }

    public String toString() {
        return "ObjectiveData [id=" + this.id + ", type=" + this.objectiveType + ", priority=" + this.priority + ", targetPlayerName=" + this.targetPlayerName + ", targetEntityUUID=" + this.targetEntityUUID + ", targetOwnerUUID=" + this.targetOwnerUUID + ", isRegistered=" + this.isRegistered + ", speedModifier=" + this.speedModifier + ", startDistance=" + this.startDistance + ", stopDistance=" + this.stopDistance + ", onlyAtNight=" + this.onlyAtNight + ", distanceToPoi=" + this.distanceToPoi + ", canDealWithDoors=" + this.canDealWithDoors + ", lookDistance=" + this.lookDistance + ", attackInterval=" + this.attackInterval + ", attackRadius=" + this.attackRadius + ", interval=" + this.interval + ", mustSeeTarget=" + this.mustSeeTarget + ", probability=" + this.probability + "]";
    }
}

