/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.trading.TradingDataSet;
import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SoundData;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;

public interface TradingData<E extends PathfinderMob>
extends EasyNPC<E>,
Merchant {
    public static final String DATA_TRADING_INVENTORY_TAG = "Inventory";
    public static final String DATA_TRADING_OFFERS_TAG = "Offers";
    public static final String DATA_TRADING_RECIPES_TAG = "Recipes";
    public static final String DATA_TRADING_DATA_TAG = "TradingData";

    public static void registerSyncedTradingData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Trading Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.TRADING_DATA_SET, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.TRADING_DATA_SET));
        map.put(SynchedDataIndex.TRADING_INVENTORY, SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135042_));
        map.put(SynchedDataIndex.TRADING_MERCHANT_OFFERS, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.MERCHANT_OFFERS));
    }

    public Player m_7962_();

    public void m_7189_(Player var1);

    public MerchantOffers getMerchantTradingOffers();

    public void setMerchantTradingOffers(MerchantOffers var1);

    default public MerchantOffers m_6616_() {
        if (this.getMerchantTradingOffers() == null) {
            this.updateMerchantTradingOffers();
        }
        return this.getMerchantTradingOffers();
    }

    default public void updateMerchantTradingOffers() {
        TradingDataSet tradingDataSet = this.getTradingDataSet();
        MerchantOffers merchantOffers = new MerchantOffers();
        if (tradingDataSet.isType(TradingType.BASIC) || tradingDataSet.isType(TradingType.ADVANCED) || tradingDataSet.isType(TradingType.CUSTOM)) {
            merchantOffers = new MerchantOffers(this.getTradingOffers().m_45388_());
        }
        if (!merchantOffers.isEmpty()) {
            merchantOffers.removeIf(merchantOffer -> merchantOffer.m_45352_().m_41619_() && merchantOffer.m_45364_().m_41619_() || merchantOffer.m_45368_().m_41619_());
        }
        this.setMerchantTradingOffers(merchantOffers);
    }

    default public void m_6255_(MerchantOffers merchantOffers) {
    }

    default public int m_7809_() {
        return 0;
    }

    default public void m_6621_(int experience) {
    }

    default public boolean m_7826_() {
        return true;
    }

    default public SoundEvent m_7596_() {
        return SoundEvents.f_12509_;
    }

    @Override
    default public boolean m_183595_() {
        return this.getLevel() != null && this.getLevel().m_5776_();
    }

    default public void setAdvancedTradingOffers(Container container) {
        MerchantOffers merchantOffers = new MerchantOffers();
        int merchantOfferIndex = 0;
        for (int tradingOffer = 0; tradingOffer < 25; ++tradingOffer) {
            MerchantOffer existingMerchantOffer;
            ItemStack itemResult;
            ItemStack itemB;
            ItemStack itemA = container.m_8020_(tradingOffer * 3);
            if (!this.isValidTradingOffer(itemA, itemB = container.m_8020_(tradingOffer * 3 + 1), itemResult = container.m_8020_(tradingOffer * 3 + 2))) continue;
            MerchantOffers existingMerchantOffers = this.getTradingOffers();
            MerchantOffer merchantOffer = existingMerchantOffer = existingMerchantOffers != null && existingMerchantOffers.size() > tradingOffer ? (MerchantOffer)existingMerchantOffers.get(tradingOffer) : null;
            if (existingMerchantOffer != null) {
                merchantOffers.add(merchantOfferIndex++, (Object)new MerchantOffer(itemA, itemB, itemResult, existingMerchantOffer.m_45371_(), existingMerchantOffer.m_45373_(), existingMerchantOffer.m_45379_(), existingMerchantOffer.m_45378_(), existingMerchantOffer.m_45375_()));
                continue;
            }
            merchantOffers.add(merchantOfferIndex++, (Object)new MerchantOffer(itemA, itemB, itemResult, 64, 1, 1.0f));
        }
        if (!merchantOffers.isEmpty()) {
            this.getTradingDataSet().setType(TradingType.ADVANCED);
            this.setTradingOffers(merchantOffers);
        }
    }

    default public void setBasicTradingOffers(Container container) {
        MerchantOffers merchantOffers = new MerchantOffers();
        for (int tradingOffer = 0; tradingOffer < 12; ++tradingOffer) {
            ItemStack itemResult;
            ItemStack itemB;
            ItemStack itemA = container.m_8020_(tradingOffer * 3);
            if (!this.isValidTradingOffer(itemA, itemB = container.m_8020_(tradingOffer * 3 + 1), itemResult = container.m_8020_(tradingOffer * 3 + 2))) continue;
            MerchantOffer merchantOffer = new MerchantOffer(itemA, itemB, itemResult, this.getTradingDataSet().getMaxUses(), this.getTradingDataSet().getRewardedXP(), 1.0f);
            merchantOffers.add((Object)merchantOffer);
        }
        if (!merchantOffers.isEmpty()) {
            this.getTradingDataSet().setType(TradingType.BASIC);
            this.setTradingOffers(merchantOffers);
        }
    }

    default public void updateBasicTradingOffers() {
        if (this.getTradingDataSet().isType(TradingType.BASIC)) {
            return;
        }
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty()) {
            return;
        }
        MerchantOffers newMerchantOffers = new MerchantOffers();
        for (MerchantOffer merchantOffer : merchantOffers) {
            if (!this.isValidTradingOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_())) continue;
            MerchantOffer newMerchantOffer = new MerchantOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_(), this.getTradingDataSet().getMaxUses(), this.getTradingDataSet().getRewardedXP(), merchantOffer.m_45378_());
            newMerchantOffers.add((Object)newMerchantOffer);
        }
        this.setTradingOffers(newMerchantOffers);
    }

    default public void resetTradingOffers() {
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty()) {
            return;
        }
        log.debug("Reset trading offers {} for {}", (Object)merchantOffers, (Object)this);
        for (MerchantOffer merchantOffer : merchantOffers) {
            merchantOffer.m_45372_();
        }
        this.setTradingOffers(merchantOffers);
        this.getTradingDataSet().setLastReset(System.currentTimeMillis());
    }

    default public MerchantOffers getTradingOffers() {
        return (MerchantOffers)this.getSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS);
    }

    default public void setTradingOffers(MerchantOffers merchantOffers) {
        this.setSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS, new MerchantOffers());
        this.setSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS, merchantOffers);
        this.updateMerchantTradingOffers();
    }

    default public CompoundTag getTradingInventory() {
        return (CompoundTag)this.getSynchedEntityData(SynchedDataIndex.TRADING_INVENTORY);
    }

    default public void setTradingInventory(CompoundTag tradingInventory) {
        this.setSynchedEntityData(SynchedDataIndex.TRADING_INVENTORY, tradingInventory);
    }

    default public void m_6996_(MerchantOffer merchantOffer) {
        merchantOffer.m_45374_();
        this.getMob().f_21363_ = -this.getMob().m_8100_();
        this.rewardTradeXp(merchantOffer);
        Player player = this.m_7962_();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            log.debug("Trade {} with {} for {}", (Object)merchantOffer, (Object)serverPlayer, (Object)this);
        }
    }

    default public void m_7713_(ItemStack itemStack) {
        if (!this.m_183595_() && this.getMob().f_21363_ > -this.getMob().m_8100_() + 20) {
            this.getMob().f_21363_ = -this.getMob().m_8100_();
            SoundData soundData = this.getEasyNPCSoundData();
            soundData.playDefaultTradeUpdatedSound(!itemStack.m_41619_());
        }
    }

    default public void rewardTradeXp(MerchantOffer merchantOffer) {
        if (merchantOffer.m_45383_() && merchantOffer.m_45379_() > 0) {
            LivingEntity livingEntity = this.getLivingEntity();
            int tradeExperience = 3 + livingEntity.m_217043_().m_188503_(merchantOffer.m_45379_());
            livingEntity.m_9236_().m_7967_((Entity)new ExperienceOrb(livingEntity.m_9236_(), livingEntity.m_20185_(), livingEntity.m_20186_() + 0.5, livingEntity.m_20189_(), tradeExperience));
        }
    }

    default public boolean hasTradingData() {
        TradingType tradingType = this.getTradingDataSet().getType();
        return (tradingType == TradingType.BASIC || tradingType == TradingType.ADVANCED) && this.getTradingOffers() != null && !this.getTradingOffers().isEmpty() || tradingType == TradingType.CUSTOM;
    }

    default public void stopTrading() {
        Merchant merchant = this.getMerchant();
        if (merchant != null) {
            merchant.m_7189_(null);
        }
    }

    default public void setAdvancedTradingMaxUses(int tradingOfferIndex, int maxUses) {
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_(), 0, maxUses, merchantOffer.m_45379_(), merchantOffer.m_45378_(), merchantOffer.m_45375_()));
        this.setTradingOffers(merchantOffers);
    }

    default public void setAdvancedTradingXp(int tradingOfferIndex, int xp) {
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_(), merchantOffer.m_45371_(), merchantOffer.m_45373_(), xp, merchantOffer.m_45378_(), merchantOffer.m_45375_()));
        this.setTradingOffers(merchantOffers);
    }

    default public void setAdvancedTradingPriceMultiplier(int tradingOfferIndex, float priceMultiplier) {
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_(), merchantOffer.m_45371_(), merchantOffer.m_45373_(), merchantOffer.m_45379_(), priceMultiplier, merchantOffer.m_45375_()));
        this.setTradingOffers(merchantOffers);
    }

    default public void setAdvancedTradingDemand(int tradingOfferIndex, int demand) {
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(merchantOffer.m_45352_(), merchantOffer.m_45364_(), merchantOffer.m_45368_(), merchantOffer.m_45371_(), merchantOffer.m_45373_(), merchantOffer.m_45379_(), merchantOffer.m_45378_(), demand));
        this.setTradingOffers(merchantOffers);
    }

    default public TradingDataSet getTradingDataSet() {
        return (TradingDataSet)this.getSynchedEntityData(SynchedDataIndex.TRADING_DATA_SET);
    }

    default public void setTradingDataSet(TradingDataSet tradingDataSet) {
        this.setSynchedEntityData(SynchedDataIndex.TRADING_DATA_SET, tradingDataSet);
    }

    default public void updateTradingDataSet() {
        TradingDataSet currentTradingDataSet = this.getTradingDataSet();
        this.setTradingDataSet(new TradingDataSet());
        this.setTradingDataSet(currentTradingDataSet);
    }

    default public boolean isValidTradingOffer(ItemStack itemA, ItemStack itemB, ItemStack itemResult) {
        if (itemResult == null || itemA == null && itemB == null) {
            return false;
        }
        return (itemA != null && !itemA.m_41619_() || itemB != null && !itemB.m_41619_()) && !itemResult.m_41619_();
    }

    default public void openTradingScreen(ServerPlayer serverPlayer) {
        if (this.m_183595_()) {
            return;
        }
        Merchant merchant = this.getMerchant();
        if (merchant == null) {
            log.error("No merchant found for {} with {} from {}", (Object)this, (Object)this.getTradingOffers(), (Object)serverPlayer);
            return;
        }
        MerchantOffers merchantOffers = merchant.m_6616_();
        if (merchantOffers.isEmpty()) {
            log.error("No trading offers found for {} with {} from {}", (Object)this, (Object)merchantOffers, (Object)serverPlayer);
            return;
        }
        if (merchant.m_7962_() != null && merchant.m_7962_() != serverPlayer) {
            log.warn("Unable to open trading screen for {} with {} from {}, {} is still trading.", (Object)this, (Object)merchantOffers, (Object)serverPlayer, (Object)merchant.m_7962_());
            serverPlayer.m_6915_();
            serverPlayer.m_213846_((Component)TextComponent.getTranslatedText("trading.busy", this.getLivingEntity(), merchant.m_7962_()));
            return;
        }
        if (this.getTradingDataSet().getResetsEveryMin() > 0) {
            long currentTime = System.currentTimeMillis();
            long resetTimeInMillis = (long)this.getTradingDataSet().getResetsEveryMin() * 60L * 1000L;
            if (currentTime - this.getTradingDataSet().getLastReset() > resetTimeInMillis) {
                this.resetTradingOffers();
            }
        }
        log.debug("Open trading screen for {} with {} from {}", (Object)this, (Object)merchantOffers, (Object)serverPlayer);
        merchant.m_7189_((Player)serverPlayer);
        merchant.m_45301_((Player)serverPlayer, (Component)(this.getEntity().m_7770_() != null ? this.getEntity().m_7770_() : TextComponent.getTranslatedText("trading")), 140);
    }

    default public void defineSynchedTradingData() {
        this.defineSynchedEntityData(SynchedDataIndex.TRADING_DATA_SET, new TradingDataSet());
        this.defineSynchedEntityData(SynchedDataIndex.TRADING_INVENTORY, new CompoundTag());
        this.defineSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS, new MerchantOffers());
    }

    default public void addAdditionalTradingData(CompoundTag compoundTag) {
        CompoundTag tradingDataTag = new CompoundTag();
        TradingDataSet tradingDataSet = this.getTradingDataSet();
        if (tradingDataSet != null) {
            tradingDataSet.save(tradingDataTag);
        }
        compoundTag.m_128365_(DATA_TRADING_DATA_TAG, (Tag)tradingDataTag);
        CompoundTag tradingOffersTag = new CompoundTag();
        tradingOffersTag.m_128365_(DATA_TRADING_INVENTORY_TAG, (Tag)this.getTradingInventory());
        tradingOffersTag.m_128365_(DATA_TRADING_RECIPES_TAG, (Tag)this.getTradingOffers().m_45388_());
        compoundTag.m_128365_(DATA_TRADING_OFFERS_TAG, (Tag)tradingOffersTag);
    }

    default public void readAdditionalTradingData(CompoundTag compoundTag) {
        CompoundTag tradingOffersTag;
        CompoundTag tradingDataTag = compoundTag.m_128469_(DATA_TRADING_DATA_TAG);
        if (tradingDataTag.m_128441_("TradingDataSet")) {
            TradingDataSet tradingDataSet = new TradingDataSet(tradingDataTag);
            this.setTradingDataSet(tradingDataSet);
        }
        if ((tradingOffersTag = compoundTag.m_128469_(DATA_TRADING_OFFERS_TAG)).m_128441_(DATA_TRADING_RECIPES_TAG)) {
            MerchantOffers merchantOffers = new MerchantOffers(tradingOffersTag.m_128469_(DATA_TRADING_RECIPES_TAG));
            if (!merchantOffers.isEmpty()) {
                log.info("Loading trading offers {} for {}", (Object)merchantOffers, (Object)this);
                this.setTradingOffers(merchantOffers);
            }
            return;
        }
        if (tradingOffersTag.m_128441_(DATA_TRADING_INVENTORY_TAG)) {
            this.setTradingInventory(tradingOffersTag.m_128469_(DATA_TRADING_INVENTORY_TAG));
        }
    }
}

