/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers;

import de.markusbordihn.easynpc.item.ModItemTags;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;

public class AttackHandler {
    public static final String CHARGED_PROJECTILES_TAG = "ChargedProjectiles";

    private AttackHandler() {
    }

    public static void addChargedProjectile(ItemStack weaponItemStack, ItemStack projectileItemStack) {
        CompoundTag weaponCompoundTag = weaponItemStack.m_41784_();
        ListTag listTag = weaponCompoundTag.m_128425_(CHARGED_PROJECTILES_TAG, 9) ? weaponCompoundTag.m_128437_(CHARGED_PROJECTILES_TAG, 10) : new ListTag();
        CompoundTag projectileCompoundTag = new CompoundTag();
        projectileItemStack.m_41739_(projectileCompoundTag);
        listTag.add((Object)projectileCompoundTag);
        weaponCompoundTag.m_128365_(CHARGED_PROJECTILES_TAG, (Tag)listTag);
    }

    public static boolean isMeeleeWeapon(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof TieredItem;
    }

    public static boolean isBowWeapon(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof BowItem || itemStack.m_204117_(ModItemTags.RANGED_WEAPON_BOW);
    }

    public static boolean isCrossbowWeapon(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof CrossbowItem || itemStack.m_204117_(ModItemTags.RANGED_WEAPON_CROSSBOW);
    }

    public static boolean isGunWeapon(ItemStack itemStack) {
        return itemStack.m_204117_(ModItemTags.RANGED_WEAPON_GUN);
    }

    public static boolean canFireProjectileWeapon(ProjectileWeaponItem projectileWeaponItem) {
        return projectileWeaponItem instanceof CrossbowItem || projectileWeaponItem instanceof BowItem;
    }

    public static boolean isHoldingBowWeapon(LivingEntity livingEntity) {
        return livingEntity != null && AttackHandler.isBowWeapon(livingEntity.m_21205_());
    }

    public static boolean isHoldingCrossbowWeapon(LivingEntity livingEntity) {
        return livingEntity != null && AttackHandler.isCrossbowWeapon(livingEntity.m_21205_());
    }

    public static boolean isHoldingGunWeapon(LivingEntity livingEntity) {
        return livingEntity != null && AttackHandler.isGunWeapon(livingEntity.m_21205_());
    }

    public static boolean isHoldingMeleeWeapon(LivingEntity livingEntity) {
        return livingEntity != null && AttackHandler.isMeeleeWeapon(livingEntity.m_21205_());
    }

    public static boolean isHoldingProjectileWeapon(LivingEntity livingEntity) {
        return livingEntity != null && livingEntity.m_21205_().m_41720_() instanceof ProjectileWeaponItem;
    }

    public static boolean isHoldingWeapon(LivingEntity livingEntity) {
        return AttackHandler.isHoldingMeleeWeapon(livingEntity) || AttackHandler.isHoldingProjectileWeapon(livingEntity);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void performDefaultRangedAttack(LivingEntity livingEntity, LivingEntity targedtedLivingEntity, float damage) {
        if (AttackHandler.isHoldingBowWeapon(livingEntity)) {
            AttackHandler.performBowAttack(livingEntity, targedtedLivingEntity, damage);
            return;
        }
        if (livingEntity instanceof CrossbowAttackMob) {
            CrossbowAttackMob crossbowAttackMob = (CrossbowAttackMob)livingEntity;
            if (AttackHandler.isHoldingCrossbowWeapon(livingEntity)) {
                AttackHandler.addChargedProjectile(livingEntity.m_21205_(), new ItemStack((ItemLike)Items.f_42412_, 1));
                crossbowAttackMob.m_32336_(livingEntity, 1.6f);
                return;
            }
        }
        if (!AttackHandler.isHoldingGunWeapon(livingEntity)) return;
        AttackHandler.performGunAttack(livingEntity, targedtedLivingEntity, damage);
    }

    public static InteractionHand getBowHoldingHand(LivingEntity livingEntity) {
        ItemStack itemStack = livingEntity.m_21205_();
        return AttackHandler.isBowWeapon(itemStack) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static InteractionHand getCrossbowHoldingHand(LivingEntity livingEntity) {
        ItemStack itemStack = livingEntity.m_21205_();
        return AttackHandler.isCrossbowWeapon(itemStack) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static InteractionHand getGunHoldingHand(LivingEntity livingEntity) {
        ItemStack itemStack = livingEntity.m_21205_();
        return AttackHandler.isGunWeapon(itemStack) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static void performGunAttack(LivingEntity livingEntity, LivingEntity livingEntityTarget, float damage) {
        AbstractArrow abstractArrow = AttackHandler.getBullet(livingEntity, damage);
        if (AttackHandler.isGunWeapon(livingEntity.m_21205_())) {
            double targetX = livingEntityTarget.m_20185_() - livingEntity.m_20185_();
            double targetY = livingEntityTarget.m_20186_() - abstractArrow.m_20186_();
            double targetZ = livingEntityTarget.m_20189_() - livingEntity.m_20189_();
            double targetRadius = Math.sqrt(targetX * targetX + targetZ * targetZ);
            abstractArrow.m_6686_(targetX, targetY + targetRadius * (double)0.2f, targetZ, 1.6f, 14.0f - (float)(livingEntity.m_9236_().m_46791_().m_19028_() * 4));
            livingEntity.m_5496_(SoundEvents.f_11874_, 1.0f, 1.0f / (livingEntity.m_217043_().m_188501_() * 0.4f + 0.8f));
            livingEntity.m_9236_().m_7967_((Entity)abstractArrow);
        }
    }

    public static void performBowAttack(LivingEntity livingEntity, LivingEntity livingEntityTarget, float damage) {
        ItemStack itemStack = livingEntity.m_6298_(livingEntity.m_21120_(AttackHandler.getBowHoldingHand(livingEntity)));
        AbstractArrow abstractArrow = AttackHandler.getArrow(livingEntity, itemStack, damage);
        if (AttackHandler.isBowWeapon(livingEntity.m_21205_())) {
            double targetX = livingEntityTarget.m_20185_() - livingEntity.m_20185_();
            double targetY = livingEntityTarget.m_20227_(0.3333333333333333) - abstractArrow.m_20186_();
            double targetZ = livingEntityTarget.m_20189_() - livingEntity.m_20189_();
            double targetRadius = Math.sqrt(targetX * targetX + targetZ * targetZ);
            abstractArrow.m_6686_(targetX, targetY + targetRadius * (double)0.2f, targetZ, 1.6f, 14.0f - (float)(livingEntity.m_9236_().m_46791_().m_19028_() * 4));
            livingEntity.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (livingEntity.m_217043_().m_188501_() * 0.4f + 0.8f));
            livingEntity.m_9236_().m_7967_((Entity)abstractArrow);
        }
    }

    public static AbstractArrow getArrow(LivingEntity livingEntity, ItemStack itemStack, float damage) {
        return ProjectileUtil.m_37300_((LivingEntity)livingEntity, (ItemStack)itemStack, (float)damage);
    }

    public static AbstractArrow getBullet(LivingEntity livingEntity, float damage) {
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("easy_npc", "bullet"));
        return ProjectileUtil.m_37300_((LivingEntity)livingEntity, (ItemStack)new ItemStack((ItemLike)item), (float)damage);
    }
}

