/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.EasyNPCBaseModelEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class HumanoidSlim
extends EasyNPCBaseModelEntity<HumanoidSlim> {
    public static final String ID = "humanoid_slim";

    public HumanoidSlim(EntityType<? extends PathfinderMob> entityType, Level level) {
        this(entityType, level, Variant.ALEX);
    }

    public HumanoidSlim(EntityType<? extends PathfinderMob> entityType, Level level, Enum<?> variant) {
        super(entityType, level, variant);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22283_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22285_, 0.0);
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.HUMANOID_SLIM;
    }

    @Override
    public Enum<?>[] getVariants() {
        return Variant.values();
    }

    @Override
    public Enum<?> getDefaultVariant() {
        return Variant.ALEX;
    }

    @Override
    public Enum<?> getVariant(String name) {
        try {
            return Variant.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultVariant();
        }
    }

    @Override
    public boolean supportsPlayerSkinConfiguration() {
        return true;
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        soundDataSet.addSound(SoundType.DEATH, SoundEvents.f_12322_);
        soundDataSet.addSound(SoundType.HURT, SoundEvents.f_12323_);
        soundDataSet.addSound(SoundType.EAT, SoundEvents.f_11912_);
        soundDataSet.addSound(SoundType.TRADE, SoundEvents.f_12508_);
        soundDataSet.addSound(SoundType.TRADE_YES, SoundEvents.f_12509_);
        soundDataSet.addSound(SoundType.TRADE_NO, SoundEvents.f_12507_);
        return soundDataSet;
    }

    public float m_6431_(Pose pose, EntityDimensions dimensions) {
        return switch (pose) {
            case Pose.SWIMMING, Pose.FALL_FLYING, Pose.SPIN_ATTACK -> 0.4f;
            case Pose.CROUCHING -> 1.27f;
            default -> 1.62f;
        };
    }

    public static enum Variant {
        ALEX,
        ARI,
        EFE,
        KAI,
        MAKENA,
        NOOR,
        STEVE,
        SUNNY,
        ZURI,
        KAWORRU;

    }
}

