/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public record ChangeActionEventMessage(UUID uuid, ActionEventType actionEventType, ActionDataSet actionDataSet) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "change_action_event");

    public static ChangeActionEventMessage create(FriendlyByteBuf buffer) {
        return new ChangeActionEventMessage(buffer.m_130259_(), (ActionEventType)buffer.m_130066_(ActionEventType.class), new ActionDataSet(buffer.m_130260_()));
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.actionEventType);
        buffer.m_130079_(this.actionDataSet.createTag());
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null || this.actionEventType == null || this.actionEventType == ActionEventType.NONE || this.actionDataSet == null) {
            log.error("Failed to change action event for {}: Invalid data", easyNPC);
            return;
        }
        int permissionLevel = 0;
        MinecraftServer minecraftServer = serverPlayer.m_20194_();
        ActionEventData<?> actionEventData = easyNPC.getEasyNPCActionEventData();
        if (minecraftServer != null) {
            permissionLevel = minecraftServer.m_129944_(serverPlayer.m_36316_());
            log.debug("Set action owner permission level {} for {} from {}", (Object)permissionLevel, easyNPC, (Object)serverPlayer);
            actionEventData.setActionPermissionLevel(permissionLevel);
        } else {
            log.warn("Unable to verify permission level from {} for {}", (Object)this, (Object)serverPlayer);
        }
        log.debug("Set action event {} with {} for {} from {} with owner permission level {}.", (Object)this.actionEventType, (Object)this.actionDataSet, easyNPC, (Object)serverPlayer, (Object)permissionLevel);
        actionEventData.getActionEventSet().setActionEvent(this.actionEventType, this.actionDataSet);
    }
}

