/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.NameHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeNameMessage(UUID uuid, String name, int color, boolean visible) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc", "change_name");

    public static ChangeNameMessage create(FriendlyByteBuf buffer) {
        return new ChangeNameMessage(buffer.m_130259_(), buffer.m_130277_(), buffer.readInt(), buffer.readBoolean());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130070_(this.name);
        buffer.writeInt(this.color);
        buffer.writeBoolean(this.visible);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (!NameHandler.setCustomName(easyNPC, this.name, this.color, this.visible)) {
            log.error("Unable to set custom name {} for {} from {}", (Object)this.name, easyNPC, (Object)serverPlayer);
        }
    }
}

