/*
 * Decompiled with CFR 0.152.
 */
package dev.the_millman.christmasfestivity.common.blocks;

import dev.the_millman.christmasfestivity.common.blocks.HorizontalFaceBlock;
import dev.the_millman.christmasfestivity.common.items.LightBulbItem;
import dev.the_millman.christmasfestivity.core.util.BulbColors;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WireBlock
extends HorizontalFaceBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty BULB = BooleanProperty.m_61465_((String)"bulb");
    public static final EnumProperty<BulbColors> BULB_COLORS = EnumProperty.m_61587_((String)"color", BulbColors.class);
    protected static final VoxelShape SHAPE_NORTH_WALL = Block.m_49796_((double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH_WALL = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)9.0, (double)4.0);
    protected static final VoxelShape SHAPE_WEST_WALL = Block.m_49796_((double)12.0, (double)4.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SHAPE_EAST_WALL = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH_CEILING = Block.m_49796_((double)0.0, (double)11.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_SOUTH_CEILING = Block.m_49796_((double)0.0, (double)11.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_WEST_CEILING = Block.m_49796_((double)6.0, (double)11.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_EAST_CEILING = Block.m_49796_((double)6.0, (double)11.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public WireBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL)).m_61124_((Property)BULB, (Comparable)Boolean.valueOf(false))).m_61124_(BULB_COLORS, (Comparable)((Object)BulbColors.NULL)));
    }

    public void m_5871_(ItemStack stack, BlockGetter getter, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"christmasfestivity.tooltip.wire"));
        super.m_5871_(stack, getter, tooltip, flag);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case CEILING: {
                switch (direction) {
                    case NORTH: {
                        return SHAPE_NORTH_CEILING;
                    }
                    case SOUTH: {
                        return SHAPE_SOUTH_CEILING;
                    }
                    case WEST: {
                        return SHAPE_WEST_CEILING;
                    }
                    case EAST: {
                        return SHAPE_EAST_CEILING;
                    }
                }
                return SHAPE_NORTH_CEILING;
            }
            case WALL: {
                switch (direction) {
                    case NORTH: {
                        return SHAPE_NORTH_WALL;
                    }
                    case SOUTH: {
                        return SHAPE_SOUTH_WALL;
                    }
                    case WEST: {
                        return SHAPE_WEST_WALL;
                    }
                    case EAST: {
                        return SHAPE_EAST_WALL;
                    }
                }
                return SHAPE_NORTH_WALL;
            }
            case FLOOR: {
                switch (direction) {
                    case NORTH: {
                        return SHAPE_NORTH_WALL;
                    }
                    case SOUTH: {
                        return SHAPE_SOUTH_WALL;
                    }
                    case WEST: {
                        return SHAPE_WEST_WALL;
                    }
                    case EAST: {
                        return SHAPE_EAST_WALL;
                    }
                }
                return SHAPE_NORTH_WALL;
            }
        }
        switch (direction) {
            case NORTH: {
                return SHAPE_NORTH_WALL;
            }
            case SOUTH: {
                return SHAPE_SOUTH_WALL;
            }
            case WEST: {
                return SHAPE_WEST_WALL;
            }
            case EAST: {
                return SHAPE_EAST_WALL;
            }
        }
        return SHAPE_NORTH_WALL;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_53179_, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_()) : (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL)).m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!blockstate.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return blockstate;
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        block6: {
            ItemStack stack;
            block5: {
                stack = player.m_21205_();
                if (((Boolean)state.m_61143_((Property)BULB)).booleanValue()) break block5;
                Item item = stack.m_41720_();
                if (!(item instanceof LightBulbItem)) break block6;
                LightBulbItem lightBulbItem = (LightBulbItem)item;
            }
            if (world.f_46443_) {
                BlockState blockstate1 = (BlockState)state.m_61122_(BULB_COLORS);
                return InteractionResult.SUCCESS;
            }
            BlockState blockstate = this.pull(state, world, pos, player);
            if (((Boolean)state.m_61143_((Property)BULB)).booleanValue() == Boolean.valueOf(false).booleanValue()) {
                int num = stack.m_41613_();
                stack.m_41764_(num - 1);
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)BULB, (Comparable)Boolean.valueOf(true)), 3);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private BlockState push(BlockState state, Level world, BlockPos pos, Player player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof LightBulbItem || ((Boolean)state.m_61143_((Property)BULB)).booleanValue()) {
            BlockState blockstate1 = (BlockState)state.m_61122_(BULB_COLORS);
            return state;
        }
        return state;
    }

    private BlockState pull(BlockState state, Level world, BlockPos pos, Player player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof LightBulbItem || ((Boolean)state.m_61143_((Property)BULB)).booleanValue()) {
            state = (BlockState)state.m_61122_(BULB_COLORS);
            world.m_7731_(pos, state, 3);
            this.updateNeighbours(state, world, pos);
            return state;
        }
        return state;
    }

    private void updateNeighbours(BlockState p_196378_1_, Level p_196378_2_, BlockPos p_196378_3_) {
        p_196378_2_.m_46672_(p_196378_3_, (Block)this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, BULB_COLORS, BULB, f_53179_});
    }
}

