/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tanukidecor.block.Side;
import tanukidecor.block.storage.IDelegateProvider;
import tanukidecor.util.MultiblockHandler;
import tanukidecor.util.ShapeBuilder;
import tanukidecor.util.ShapeUtils;

public class RotatingWideBlock
extends Block
implements SimpleWaterloggedBlock,
IDelegateProvider {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Side> SIDE = EnumProperty.m_61587_((String)"side", Side.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected final ShapeBuilder shapeBuilder;
    protected final Map<BlockState, VoxelShape> blockShapes = new HashMap<BlockState, VoxelShape>();
    protected final Map<BlockState, VoxelShape> multiblockShapes = new HashMap<BlockState, VoxelShape>();

    public RotatingWideBlock(BlockBehaviour.Properties pProperties, ShapeBuilder shapeBuilder) {
        super(pProperties);
        this.shapeBuilder = shapeBuilder;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(FACING, (Comparable)Direction.NORTH)).m_61124_(SIDE, (Comparable)((Object)Side.LEFT)));
        this.precalculateShapes();
    }

    protected void precalculateShapes() {
        this.blockShapes.clear();
        this.multiblockShapes.clear();
        EnumMap<Direction, VoxelShape> doubleBlockShapes = new EnumMap<Direction, VoxelShape>(Direction.class);
        doubleBlockShapes.putAll(ShapeUtils.rotateShapes(MultiblockHandler.ORIGIN_DIRECTION, this.createDoubleBlockShape()));
        for (BlockState blockState : this.f_49792_.m_61056_()) {
            this.blockShapes.put(blockState, (VoxelShape)this.shapeBuilder.apply(blockState));
            Direction facing = (Direction)blockState.m_61143_(FACING);
            Direction direction = facing.m_122427_();
            double offset = blockState.m_61143_(SIDE) == Side.LEFT ? 0.0 : 1.0;
            VoxelShape shape = ((VoxelShape)doubleBlockShapes.get(facing)).m_83216_(offset * (double)direction.m_122429_(), 0.0, offset * (double)direction.m_122431_());
            this.multiblockShapes.put(blockState, shape);
        }
    }

    protected VoxelShape createDoubleBlockShape() {
        BlockState leftState = (BlockState)this.m_49966_().m_61124_(SIDE, (Comparable)((Object)Side.LEFT));
        BlockState rightState = (BlockState)this.m_49966_().m_61124_(SIDE, (Comparable)((Object)Side.RIGHT));
        return Shapes.m_83110_((VoxelShape)this.blockShapes.computeIfAbsent(leftState, this.shapeBuilder), (VoxelShape)this.blockShapes.computeIfAbsent(rightState, this.shapeBuilder).m_83216_(-1.0, 0.0, 0.0));
    }

    public VoxelShape getBlockShape(BlockState blockState) {
        return this.blockShapes.get(blockState);
    }

    public VoxelShape getMultiblockShape(BlockState blockState) {
        return this.multiblockShapes.get(blockState);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.f_60443_ ? this.getBlockShape(pState) : Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.getMultiblockShape(pState);
    }

    @Override
    public BlockPos getDelegatePos(BlockState blockState, BlockPos blockPos) {
        return RotatingWideBlock.getLeftSide(blockState, blockPos);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean waterlogged = fluidstate.m_76152_() == Fluids.f_76193_;
        Direction direction = pContext.m_8125_().m_122424_();
        BlockPos sidePos = blockpos.m_121945_(direction.m_122428_());
        if (level.m_8055_(sidePos).m_60629_(pContext)) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).m_61124_(SIDE, (Comparable)((Object)Side.LEFT));
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{SIDE}).m_61104_(new Property[]{FACING});
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        Side side = (Side)((Object)pState.m_61143_(SIDE));
        BlockPos oppositePos = RotatingWideBlock.getOppositeSide(pState, pCurrentPos);
        BlockState oppositeState = pLevel.m_8055_(oppositePos);
        if (!oppositeState.m_60713_((Block)this) || oppositeState.m_61143_(SIDE) == side || !pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            return pState.m_60819_().m_76188_();
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        BlockPos sidePos = RotatingWideBlock.getRightSide(pState, pPos);
        boolean waterlogged = pLevel.m_6425_(sidePos).m_76152_() == Fluids.f_76193_;
        pLevel.m_7731_(sidePos, (BlockState)((BlockState)pState.m_61124_(SIDE, (Comparable)((Object)Side.RIGHT))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), 3);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (!pLevel.m_8055_(pPos).m_60713_((Block)this)) {
            return true;
        }
        return pState.m_61143_(SIDE) == Side.LEFT || pLevel.m_8055_(RotatingWideBlock.getOppositeSide(pState, pPos)).m_60713_((Block)this);
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.f_46443_ && pPlayer.m_7500_()) {
            this.preventCreativeDropFromLeftPart(pLevel, pPos, pState, pPlayer);
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.BLOCK;
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public static ShapeBuilder createShapeBuilder(VoxelShape shapeEast, VoxelShape shapeWest) {
        return blockState -> {
            Direction facing = (Direction)blockState.m_61143_(FACING);
            Side side = (Side)((Object)((Object)blockState.m_61143_(SIDE)));
            VoxelShape shape = side == Side.LEFT ? shapeEast : shapeWest;
            return ShapeUtils.rotateShape(MultiblockHandler.ORIGIN_DIRECTION, facing, shape);
        };
    }

    public void preventCreativeDropFromLeftPart(Level level, BlockPos pos, BlockState blockState, Player player) {
        BlockPos origin = RotatingWideBlock.getLeftSide(blockState, pos);
        BlockState originState = level.m_8055_(origin);
        if (originState.m_60713_(blockState.m_60734_()) && originState.m_61143_(SIDE) == Side.LEFT) {
            level.m_7731_(origin, originState.m_60819_().m_76188_(), 35);
        }
    }

    public static BlockPos getLeftSide(BlockState blockState, BlockPos pos) {
        if (blockState.m_61143_(SIDE) == Side.LEFT) {
            return pos;
        }
        Direction facing = (Direction)blockState.m_61143_(FACING);
        return pos.m_121945_(facing.m_122427_());
    }

    public static BlockPos getRightSide(BlockState blockState, BlockPos pos) {
        if (blockState.m_61143_(SIDE) == Side.RIGHT) {
            return pos;
        }
        Direction facing = (Direction)blockState.m_61143_(FACING);
        return pos.m_121945_(facing.m_122428_());
    }

    public static BlockPos getOppositeSide(BlockState blockState, BlockPos pos) {
        Direction facing = (Direction)blockState.m_61143_(FACING);
        Direction direction = blockState.m_61143_(SIDE) == Side.LEFT ? facing.m_122428_() : facing.m_122427_();
        return pos.m_121945_(direction);
    }
}

