/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.clock;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tanukidecor.TDRegistry;
import tanukidecor.block.RotatingMultiblock;
import tanukidecor.block.clock.IChimeProvider;
import tanukidecor.block.entity.ClockBlockEntity;
import tanukidecor.util.MultiblockHandler;
import tanukidecor.util.ShapeUtils;

public class StationClockBlock
extends RotatingMultiblock
implements EntityBlock,
IChimeProvider {
    protected final Supplier<SoundEvent> tickSound = TDRegistry.SoundReg.CLOCK_TOWER_TICK;
    public static VoxelShape SHAPE = StationClockBlock.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);

    public StationClockBlock(BlockBehaviour.Properties pProperties) {
        super(MultiblockHandler.MULTIBLOCK_2X2X1, StationClockBlock::buildShape, pProperties);
    }

    @Override
    @Nullable
    public SoundEvent getTickSound(BlockState blockState) {
        return this.tickSound.get();
    }

    @Override
    public float getTickVolume(BlockState blockState, RandomSource random, long dayTime) {
        return 1.5f;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (this.getMultiblockHandler().isCenterState(pState)) {
            return ((BlockEntityType)TDRegistry.BlockEntityReg.STATION_CLOCK.get()).m_155264_(pPos, pState);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return !pLevel.m_5776_() ? ClockBlockEntity::tick : null;
    }

    public static VoxelShape buildShape(BlockState blockState) {
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        return ShapeUtils.rotateShape(MultiblockHandler.ORIGIN_DIRECTION, facing, SHAPE);
    }
}

