/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import tanukidecor.block.misc.HourglassBlock;

public class HourglassBlockEntity
extends BlockEntity {
    public static final int TIME = 600;
    private int maxTimer;
    private int timer;
    private static final String KEY_TIMER = "Timer";
    private static final String KEY_TIMER_MAX = "TimerMax";

    public HourglassBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, HourglassBlockEntity blockEntity) {
        if (blockEntity.isActive()) {
            blockEntity.updateTimer();
        }
    }

    public int getRedstoneStrength() {
        if (this.isActive()) {
            return Mth.m_14167_((float)((float)this.timer / (float)this.maxTimer * 15.0f));
        }
        return 0;
    }

    public float getPercentageComplete(float partialTick) {
        if (!this.isActive()) {
            return 1.0f;
        }
        return 1.0f - (float)this.timer / (float)this.maxTimer;
    }

    public boolean isActive() {
        return this.timer > 0 && this.maxTimer > 0;
    }

    protected void updateTimer() {
        int redstone = this.getRedstoneStrength();
        if (--this.timer <= 0) {
            this.stopTimer();
            return;
        }
        if (this.m_58904_() != null && !this.m_58904_().m_5776_()) {
            if (redstone != this.getRedstoneStrength()) {
                this.m_58904_().m_46717_(this.m_58899_(), this.m_58900_().m_60734_());
            }
            this.m_6596_();
        }
    }

    public void startTimer(int timer) {
        this.maxTimer = timer;
        this.timer = timer;
        if (this.m_58904_() != null && !this.m_58904_().m_5776_()) {
            this.m_6596_();
            BlockState newState = (BlockState)this.m_58904_().m_8055_(this.m_58899_()).m_61124_((Property)HourglassBlock.ACTIVE, (Comparable)Boolean.valueOf(true));
            this.m_58904_().m_7731_(this.m_58899_(), newState, 3);
            this.m_58904_().m_7260_(this.m_58899_(), newState, newState, 3);
            this.m_58904_().m_46717_(this.m_58899_(), newState.m_60734_());
            this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_11985_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * this.m_58904_().m_213780_().m_188501_());
            this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_12334_, SoundSource.BLOCKS, 1.0f, 0.8f + 0.4f * this.m_58904_().m_213780_().m_188501_());
        }
    }

    public void stopTimer() {
        this.maxTimer = 0;
        this.timer = 0;
        if (this.m_58904_() != null && !this.m_58904_().m_5776_()) {
            this.m_6596_();
            BlockState newState = (BlockState)this.m_58904_().m_8055_(this.m_58899_()).m_61124_((Property)HourglassBlock.ACTIVE, (Comparable)Boolean.valueOf(false));
            this.m_58904_().m_7731_(this.m_58899_(), newState, 3);
            this.m_58904_().m_7260_(this.m_58899_(), newState, newState, 3);
            this.m_58904_().m_46717_(this.m_58899_(), newState.m_60734_());
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.timer = pTag.m_128451_(KEY_TIMER);
        this.maxTimer = pTag.m_128451_(KEY_TIMER_MAX);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_(KEY_TIMER, this.timer);
        pTag.m_128405_(KEY_TIMER_MAX, this.maxTimer);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_(KEY_TIMER, this.timer);
        tag.m_128405_(KEY_TIMER_MAX, this.maxTimer);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

