/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import tanukidecor.block.RotatingTallBlock;
import tanukidecor.block.entity.SingleSlotBlockEntity;
import tanukidecor.block.misc.PhonographBlock;

public class PhonographBlockEntity
extends SingleSlotBlockEntity {
    protected boolean isPlaying;
    protected long recordStartedTick;
    protected long tickCount;
    protected int ticksSinceLastEvent;
    private static final String KEY_IS_PLAYING = "IsPlaying";
    private static final String KEY_RECORD_STARTED_TICK = "RecordStartTick";
    private static final String KEY_TICK_COUNT = "TickCount";

    public PhonographBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, PhonographBlockEntity blockEntity) {
        blockEntity.phonographTick(level, blockPos, blockState);
    }

    public static InteractionResult use(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof PhonographBlockEntity)) {
            return InteractionResult.FAIL;
        }
        PhonographBlockEntity blockEntity2 = (PhonographBlockEntity)blockEntity;
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!blockEntity2.m_7983_()) {
            ItemStack record = blockEntity2.m_272036_();
            blockEntity2.m_6211_();
            if (player.m_21120_(hand).m_41619_()) {
                player.m_21008_(hand, record);
            } else if (!player.m_150109_().m_36054_(record)) {
                Block.m_49840_((Level)level, (BlockPos)pos.m_7494_(), (ItemStack)record);
            }
            level.m_46796_(1011, pos, 0);
            blockEntity2.setHasRecordBlockState((Entity)player, false);
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (blockEntity2.m_7983_() && !itemStack.m_41619_() && blockEntity2.m_7013_(0, itemStack)) {
            ItemStack record = itemStack.m_41620_(blockEntity2.m_6893_());
            blockEntity2.m_272287_(record);
            blockEntity2.setHasRecordBlockState((Entity)player, true);
            player.m_36220_(Stats.f_12965_);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public static void onRemove(BlockState blockState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        PhonographBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof PhonographBlockEntity && !(blockEntity = (PhonographBlockEntity)blockEntity2).m_7983_()) {
            level.m_46796_(1011, pos, 0);
            blockEntity.dropContents();
        }
    }

    protected void phonographTick(Level level, BlockPos blockPos, BlockState blockState) {
        Item item;
        ++this.ticksSinceLastEvent;
        if (this.isRecordPlaying() && (item = this.m_272036_().m_41720_()) instanceof RecordItem) {
            RecordItem record = (RecordItem)item;
            if (this.shouldRecordStopPlaying(record)) {
                this.stopPlaying();
            } else if (this.shouldSendJukeboxPlayingEvent()) {
                this.ticksSinceLastEvent = 0;
                this.spawnMusicParticles(level, blockPos.m_7494_());
            }
        }
        ++this.tickCount;
    }

    protected boolean shouldSendJukeboxPlayingEvent() {
        return this.ticksSinceLastEvent >= 20;
    }

    protected void setHasRecordBlockState(@Nullable Entity entity, boolean hasRecord) {
        if (this.f_58857_ != null && this.f_58857_.m_8055_(this.m_58899_()) == this.m_58900_()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)PhonographBlock.HAS_RECORD, (Comparable)Boolean.valueOf(hasRecord)), 3);
            this.f_58857_.m_142346_(entity, GameEvent.f_157792_, this.m_58899_());
            this.f_58857_.m_7731_(this.m_58899_().m_7494_(), (BlockState)this.f_58857_.m_8055_(this.m_58899_().m_7494_()).m_61124_((Property)PhonographBlock.HAS_RECORD, (Comparable)Boolean.valueOf(hasRecord)), 2);
            this.f_58857_.m_142346_(entity, GameEvent.f_157792_, this.m_58899_().m_7494_());
        }
    }

    protected void spawnMusicParticles(Level pLevel, BlockPos pPos) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)pLevel;
            Direction direction = (Direction)this.m_58900_().m_61143_((Property)RotatingTallBlock.f_54117_);
            Vec3 vec3 = Vec3.m_82512_((Vec3i)pPos).m_82520_(0.4 * (double)direction.m_122429_(), -0.125, 0.4 * (double)direction.m_122431_());
            float f = (float)pLevel.m_213780_().m_188503_(4) / 24.0f;
            serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123758_, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), 0, (double)f, 0.0, 0.0, 1.0);
        }
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        return pStack.m_204117_(ItemTags.f_13158_) && this.m_8020_(pIndex).m_41619_();
    }

    public int m_6893_() {
        return 1;
    }

    @Override
    public void m_6836_(int pSlot, ItemStack pStack) {
        super.m_6836_(pSlot, pStack);
        if (pStack.m_204117_(ItemTags.f_13158_) && this.f_58857_ != null) {
            this.getInventory().set(pSlot, (Object)pStack);
            this.setHasRecordBlockState(null, true);
            this.startPlaying();
        }
    }

    @Override
    public ItemStack m_7407_(int pSlot, int pAmount) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.getInventory(), (int)pSlot, (int)pAmount);
        if (!itemstack.m_41619_()) {
            this.setHasRecordBlockState(null, false);
            this.stopPlaying();
        }
        return itemstack;
    }

    public ItemStack m_272036_() {
        return this.m_8020_(0);
    }

    public void m_272287_(ItemStack pRecord) {
        this.m_6836_(0, pRecord);
    }

    protected void startPlaying() {
        this.recordStartedTick = this.tickCount;
        this.isPlaying = true;
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        this.f_58857_.m_5898_(null, 1010, this.m_58899_(), Item.m_41393_((Item)this.m_272036_().m_41720_()));
        this.m_6596_();
    }

    protected void stopPlaying() {
        this.isPlaying = false;
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        this.f_58857_.m_46796_(1011, this.m_58899_(), 0);
        this.m_6596_();
    }

    protected long getRecordLengthInTicks(RecordItem recordItem) {
        return recordItem.m_43036_();
    }

    protected boolean shouldRecordStopPlaying(RecordItem recordItem) {
        return this.tickCount >= this.recordStartedTick + this.getRecordLengthInTicks(recordItem) + 20L;
    }

    public boolean isRecordPlaying() {
        return !this.m_272036_().m_41619_() && this.isPlaying;
    }

    @Override
    public void m_6211_() {
        this.inventory.clear();
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.isPlaying = pTag.m_128471_(KEY_IS_PLAYING);
        this.recordStartedTick = pTag.m_128454_(KEY_RECORD_STARTED_TICK);
        this.tickCount = pTag.m_128454_(KEY_TICK_COUNT);
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128379_(KEY_IS_PLAYING, this.isPlaying);
        pTag.m_128356_(KEY_RECORD_STARTED_TICK, this.recordStartedTick);
        pTag.m_128356_(KEY_TICK_COUNT, this.tickCount);
    }

    @Override
    protected String getItemNbtKey() {
        return "RecordItem";
    }
}

