/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.misc;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tanukidecor.TDRegistry;
import tanukidecor.block.RotatingBlock;
import tanukidecor.block.clock.IChimeProvider;
import tanukidecor.block.entity.MetronomeBlockEntity;

public class MetronomeBlock
extends RotatingBlock
implements EntityBlock,
IChimeProvider {
    public static final int MAX_SPEED = 7;
    public static final IntegerProperty SPEED = IntegerProperty.m_61631_((String)"speed", (int)0, (int)7);
    protected final Supplier<SoundEvent> tickSound = TDRegistry.SoundReg.METRONOME_TICK;
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)MetronomeBlock.m_49796_((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)3.0, (double)11.0), (VoxelShape[])new VoxelShape[]{MetronomeBlock.m_49796_((double)5.0, (double)3.0, (double)7.0, (double)11.0, (double)10.0, (double)11.0), MetronomeBlock.m_49796_((double)7.0, (double)10.0, (double)7.0, (double)9.0, (double)11.0, (double)11.0)});

    public MetronomeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties, RotatingBlock.createShapeBuilder(SHAPE));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)SPEED, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{SPEED}));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!pPlayer.m_6144_()) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)SPEED), 3);
            pLevel.m_46717_(pPos, pState.m_60734_());
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    @Override
    @Nullable
    public SoundEvent getTickSound(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)SPEED) > 0 ? this.tickSound.get() : null;
    }

    @Override
    public int getTickSoundInterval(BlockState blockState) {
        int speed = (Integer)blockState.m_61143_((Property)SPEED);
        if (speed == 0) {
            return Integer.MAX_VALUE;
        }
        return 2 + (7 - speed) * 4;
    }

    @Override
    public boolean isTimeToChime(BlockState blockState, long dayTime) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)TDRegistry.BlockEntityReg.METRONOME.get()).m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return MetronomeBlockEntity::tick;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)SPEED);
    }
}

