/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.client.blockentity.clock;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import tanukidecor.block.entity.ClockBlockEntity;
import tanukidecor.client.blockentity.clock.ClockRenderHelper;

public class ClockBER
implements BlockEntityRenderer<ClockBlockEntity> {
    public static final ResourceLocation EMPTY = new ResourceLocation("block/air");
    public static final Vec3 ROOT_POSITION = new Vec3(0.5, 0.5, 0.0);
    public static final Vec3 ROOT_PIVOT_POINT = new Vec3(0.5, 0.0, 0.5);
    public static final Vec3 HANDS_POSITION = new Vec3(-0.5, -0.5, 0.0);
    protected final BlockRenderDispatcher blockRenderer;
    protected final ClockRenderHelper clockRenderHelper;
    protected final ResourceLocation shortHand;
    protected final ResourceLocation longHand;
    protected final Vec3 rootPosition;
    protected final Vec3 rootPivotPoint;
    protected final Vec3 handsPosition;
    protected final Vec3 handsPivotPoint;

    public ClockBER(BlockEntityRendererProvider.Context pContext, ResourceLocation shortHand, ResourceLocation longHand, Vec3 rootPosition, Vec3 rootPivotPoint, Vec3 handsPosition, Vec3 handsPivotPoint) {
        this.shortHand = shortHand;
        this.longHand = longHand;
        this.rootPosition = rootPosition;
        this.rootPivotPoint = rootPivotPoint;
        this.handsPosition = handsPosition;
        this.handsPivotPoint = handsPivotPoint;
        this.blockRenderer = pContext.m_173584_();
        this.clockRenderHelper = new ClockRenderHelper();
    }

    public void render(ClockBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Minecraft mc = Minecraft.m_91087_();
        BlockState blockState = pBlockEntity.m_58900_();
        Direction direction = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        Level level = pBlockEntity.m_58904_();
        long dayTime = (level.m_46468_() + 6000L) % 24000L;
        float hourAngleInterval = 0.5235988f;
        float hourRotation = ClockBlockEntity.getHour(dayTime, pPartialTick) * 0.5235988f;
        float minuteRotation = ClockBlockEntity.getMinute(dayTime, 0.98f) * ((float)Math.PI * 2);
        pPoseStack.m_85836_();
        this.clockRenderHelper.withPoseStack(pPoseStack).withBlockState(blockState).withRenderType(pBufferSource, RenderType.m_110463_()).withPackedLight(pPackedLight).withPackedOverlay(pPackedOverlay).withPartialTick(pPartialTick).withRotationZ(0.0f).withRandom(level.m_213780_());
        this.clockRenderHelper.withPosition(this.rootPosition).withPivotPoint(this.rootPivotPoint).rotateForDirection(direction);
        if (this.shortHand != null) {
            this.clockRenderHelper.withModel(mc.m_91304_().getModel(this.shortHand)).withPosition(this.handsPosition).withPivotPoint(this.handsPivotPoint).withRotationZ(hourRotation).render(this.blockRenderer);
        }
        if (this.longHand != null) {
            this.clockRenderHelper.withModel(mc.m_91304_().getModel(this.longHand)).withPosition(this.handsPosition).withPivotPoint(this.handsPivotPoint).withRotationZ(minuteRotation).render(this.blockRenderer);
        }
        this.renderAdditional(this.clockRenderHelper, pBlockEntity, pBufferSource);
        pPoseStack.m_85849_();
    }

    public void renderAdditional(ClockRenderHelper renderHelper, ClockBlockEntity blockEntity, MultiBufferSource bufferSource) {
    }

    public static float getPendulumRotation(float speed, float maximumAngle, long time, float partialTick) {
        return Mth.m_14031_((float)(ClockBlockEntity.getSecond(time % 24000L, partialTick) * speed * ((float)Math.PI * 2))) * maximumAngle;
    }
}

