/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.client.blockentity.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import tanukidecor.block.clock.IChimeProvider;
import tanukidecor.block.entity.MetronomeBlockEntity;
import tanukidecor.block.misc.MetronomeBlock;
import tanukidecor.client.blockentity.clock.ClockBER;
import tanukidecor.client.blockentity.clock.ClockRenderHelper;

public class MetronomeBER
implements BlockEntityRenderer<MetronomeBlockEntity> {
    public static final ResourceLocation PENDULUM = new ResourceLocation("tanukidecor", "block/metronome/pendulum");
    private static final Vec3 PENDULUM_POSITION = new Vec3(-0.5, -0.5, 0.0);
    private static final Vec3 PENDULUM_PIVOT_POINT = new Vec3(0.5, 0.1875, 0.0);
    protected final BlockRenderDispatcher blockRenderer;
    protected final ClockRenderHelper clockRenderHelper;

    public MetronomeBER(BlockEntityRendererProvider.Context pContext) {
        this.blockRenderer = pContext.m_173584_();
        this.clockRenderHelper = new ClockRenderHelper();
    }

    public void render(MetronomeBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        float pendulumRotation;
        Minecraft mc = Minecraft.m_91087_();
        BlockState blockState = pBlockEntity.m_58900_();
        Direction direction = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        BakedModel pendulum = mc.m_91304_().getModel(PENDULUM);
        int blockSpeed = (Integer)blockState.m_61143_((Property)MetronomeBlock.SPEED);
        if (blockSpeed == 0) {
            pendulumRotation = 0.0f;
        } else {
            int tickInterval = ((IChimeProvider)blockState.m_60734_()).getTickSoundInterval(blockState);
            float time = (float)(pBlockEntity.m_58904_().m_46467_() % 12000L) + pPartialTick;
            float speed = (float)Math.PI / (float)tickInterval;
            float angle = 0.5235988f;
            pendulumRotation = (float)pBlockEntity.getBias() * Mth.m_14031_((float)(time * speed)) * 0.5235988f;
        }
        pPoseStack.m_85836_();
        this.clockRenderHelper.withPoseStack(pPoseStack).withBlockState(blockState).withRenderType(pBufferSource, RenderType.m_110463_()).withPackedLight(pPackedLight).withPackedOverlay(pPackedOverlay).withPartialTick(pPartialTick).withRandom(pBlockEntity.m_58904_().m_213780_()).withRotationZ(0.0f);
        this.clockRenderHelper.withPosition(ClockBER.ROOT_POSITION).withPivotPoint(ClockBER.ROOT_PIVOT_POINT).rotateForDirection(direction);
        this.clockRenderHelper.withModel(pendulum).withPosition(PENDULUM_POSITION).withPivotPoint(PENDULUM_PIVOT_POINT).withRotationZ(pendulumRotation).render(this.blockRenderer);
        pPoseStack.m_85849_();
    }

    public static void addSpecialModels(Set<ResourceLocation> list) {
        list.add(PENDULUM);
    }
}

