/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.client.blockentity.misc;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import tanukidecor.block.entity.PlasmaBallBlockEntity;
import tanukidecor.block.misc.PlasmaBallBlock;

public class PlasmaBallBER
implements BlockEntityRenderer<PlasmaBallBlockEntity> {
    private static final Vector4f ONE = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static final Vector3f HALF = new Vector3f(0.5f, 0.5f, 0.5f);

    public PlasmaBallBER(BlockEntityRendererProvider.Context pContext) {
    }

    public void render(PlasmaBallBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState blockState = blockEntity.m_58900_();
        if (!((Boolean)blockState.m_61143_((Property)PlasmaBallBlock.ENABLED)).booleanValue()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int segments = 6;
        float size = 0.0625f;
        float mul = 0.875f;
        long time = blockEntity.m_58904_().m_46467_() % 24000L;
        for (PlasmaBallBlockEntity.Arc arc : blockEntity.getArcs()) {
            Vector3f start = new Vector3f();
            Vector3f end = new Vector3f();
            start = arc.getPosition(0.0f, time += 10L, partialTick);
            start.mul(0.875f);
            start.add((Vector3fc)HALF);
            for (int i = 0; i < 6; ++i) {
                float startPercent = (float)i / 6.0f;
                float endPercent = (float)(i + 1) / 6.0f;
                end = arc.getPosition(endPercent, time, partialTick);
                end.mul(0.875f);
                end.add((Vector3fc)HALF);
                PlasmaBallBER.renderRect(poseStack, arc.getColor(startPercent), arc.getColor(endPercent), start, end, 0.0625f);
                start.set(end.x(), end.y(), end.z());
            }
        }
        RenderSystem.disableBlend();
    }

    protected static void renderRect(PoseStack poseStack, Vector4f startColor, Vector4f endColor, Vector3f start, Vector3f end, float size) {
        float dsize = size / 2.0f;
        PoseStack.Pose lastPose = poseStack.m_85850_();
        Matrix4f matrix4f = lastPose.m_252922_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(matrix4f, start.x() + dsize, start.y() - dsize, start.z() + dsize).m_85950_(startColor.x(), startColor.y(), startColor.z(), startColor.w()).m_5752_();
        buffer.m_252986_(matrix4f, start.x() + dsize, start.y() + dsize, start.z() + dsize).m_85950_(startColor.x(), startColor.y(), startColor.z(), startColor.w()).m_5752_();
        buffer.m_252986_(matrix4f, end.x() + dsize, end.y() + dsize, end.z() + dsize).m_85950_(endColor.x(), endColor.y(), endColor.z(), endColor.w()).m_5752_();
        buffer.m_252986_(matrix4f, end.x() + dsize, end.y() - dsize, end.z() + dsize).m_85950_(endColor.x(), endColor.y(), endColor.z(), endColor.w()).m_5752_();
        tesselator.m_85914_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(matrix4f, end.x() - dsize, end.y() - dsize, end.z() - dsize).m_85950_(endColor.x(), endColor.y(), endColor.z(), endColor.w()).m_5752_();
        buffer.m_252986_(matrix4f, end.x() - dsize, end.y() + dsize, end.z() - dsize).m_85950_(endColor.x(), endColor.y(), endColor.z(), endColor.w()).m_5752_();
        buffer.m_252986_(matrix4f, start.x() - dsize, start.y() + dsize, start.z() - dsize).m_85950_(startColor.x(), startColor.y(), startColor.z(), startColor.w()).m_5752_();
        buffer.m_252986_(matrix4f, start.x() - dsize, start.y() - dsize, start.z() - dsize).m_85950_(startColor.x(), startColor.y(), startColor.z(), startColor.w()).m_5752_();
        tesselator.m_85914_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(matrix4f, start.x() - dsize, start.y() - dsize, start.z() - dsize).m_85950_(startColor.x(), startColor.y(), startColor.z(), startColor.w()).m_5752_();
        buffer.m_252986_(matrix4f, start.x() + dsize, start.y() - dsize, start.z() + dsize).m_85950_(startColor.x(), startColor.y(), startColor.z(), startColor.w()).m_5752_();
        buffer.m_252986_(matrix4f, end.x() + dsize, end.y() - dsize, end.z() + dsize).m_85950_(endColor.x(), endColor.y(), endColor.z(), endColor.w()).m_5752_();
        buffer.m_252986_(matrix4f, end.x() - dsize, end.y() - dsize, end.z() - dsize).m_85950_(endColor.x(), endColor.y(), endColor.z(), endColor.w()).m_5752_();
        tesselator.m_85914_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(matrix4f, end.x() - dsize, end.y() + dsize, end.z() - dsize).m_85950_(endColor.x(), endColor.y(), endColor.z(), endColor.w()).m_5752_();
        buffer.m_252986_(matrix4f, end.x() + dsize, end.y() + dsize, end.z() + dsize).m_85950_(endColor.x(), endColor.y(), endColor.z(), endColor.w()).m_5752_();
        buffer.m_252986_(matrix4f, start.x() + dsize, start.y() + dsize, start.z() + dsize).m_85950_(startColor.x(), startColor.y(), startColor.z(), startColor.w()).m_5752_();
        buffer.m_252986_(matrix4f, start.x() - dsize, start.y() + dsize, start.z() - dsize).m_85950_(startColor.x(), startColor.y(), startColor.z(), startColor.w()).m_5752_();
        tesselator.m_85914_();
    }
}

