/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.forge;

import java.util.ArrayList;
import java.util.HashMap;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.event.forge.ForgeChatEvents;
import journeymap.client.event.forge.ForgeChunkEvents;
import journeymap.client.event.forge.ForgeClientTickEvent;
import journeymap.client.event.forge.ForgeHudOverlayEvents;
import journeymap.client.event.forge.ForgeLoggedInEvent;
import journeymap.client.event.forge.ForgePopupCustomEvents;
import journeymap.client.event.forge.ForgeRenderLevelLastEvent;
import journeymap.client.event.forge.ForgeTextureStitchedEvent;
import journeymap.client.event.forge.ForgeWorldEvent;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraftforge.common.MinecraftForge;

public class ForgeEventHandlerManager {
    private static HashMap<Class<? extends EventHandler>, EventHandler> handlers = new HashMap();

    public static void registerHandlers() {
        ForgeEventHandlerManager.register(JourneymapClient.getInstance().getKeyEvents());
        ForgeEventHandlerManager.register(new ForgeChatEvents());
        ForgeEventHandlerManager.register(new ForgeHudOverlayEvents());
        ForgeEventHandlerManager.register(new ForgeWorldEvent());
        ForgeEventHandlerManager.register(new ForgeChunkEvents());
        ForgeEventHandlerManager.register(new ForgeClientTickEvent());
        ForgeEventHandlerManager.register(new ForgeRenderLevelLastEvent());
        ForgeEventHandlerManager.register(new ForgeLoggedInEvent());
        ForgeEventHandlerManager.register(new ForgeTextureStitchedEvent());
        ForgeEventHandlerManager.register(new ForgePopupCustomEvents());
        ColorManager.INSTANCE.getDeclaringClass();
    }

    public static void unregisterAll() {
        ArrayList<Class<? extends EventHandler>> list = new ArrayList<Class<? extends EventHandler>>(handlers.keySet());
        for (Class<? extends EventHandler> handlerClass : list) {
            ForgeEventHandlerManager.unregister(handlerClass);
        }
    }

    public static void register(EventHandler handler) {
        Class<?> handlerClass = handler.getClass();
        if (handlers.containsKey(handlerClass)) {
            Journeymap.getLogger().warn("Handler already registered: " + handlerClass.getName());
            return;
        }
        try {
            MinecraftForge.EVENT_BUS.register((Object)handler);
            Journeymap.getLogger().debug("Handler registered: " + handlerClass.getName());
            handlers.put(handler.getClass(), handler);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(handlerClass.getName() + " registration FAILED: " + LogFormatter.toString(t));
        }
    }

    public static void unregister(Class<? extends EventHandler> handlerClass) {
        EventHandler handler = handlers.remove(handlerClass);
        if (handler != null) {
            try {
                MinecraftForge.EVENT_BUS.unregister((Object)handler);
                Journeymap.getLogger().debug("Handler unregistered: " + handlerClass.getName());
            }
            catch (Throwable t) {
                Journeymap.getLogger().error(handler + " unregistration FAILED: " + LogFormatter.toString(t));
            }
        }
    }

    public static HashMap<Class<? extends EventHandler>, EventHandler> getHandlers() {
        return handlers;
    }

    public static interface EventHandler {
    }
}

