/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.events;

import com.armilp.ezvcsurvival.config.VoiceConfig;
import com.armilp.ezvcsurvival.data.ArmorEffect;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ArmorEventHandler {
    private static final Map<String, ArmorEffect> armorEffectsMap = new HashMap<String, ArmorEffect>();
    private static boolean initialized = false;

    private static void init() {
        if (initialized) {
            return;
        }
        List configList = (List)VoiceConfig.ARMOR_EFFECTS.get();
        for (String entry : configList) {
            String[] parts = entry.split("=");
            if (parts.length != 2) continue;
            String itemId = parts[0].trim();
            String[] values = parts[1].split(",");
            if (values.length != 2) continue;
            try {
                double speedMultiplier = Double.parseDouble(values[0].trim());
                double rangeMultiplier = Double.parseDouble(values[1].trim());
                armorEffectsMap.put(itemId, new ArmorEffect(speedMultiplier, rangeMultiplier));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        initialized = true;
    }

    public static double[] getArmorMultipliers(Player player) {
        ArmorEventHandler.init();
        double speedMultiplier = 1.0;
        double rangeMultiplier = 1.0;
        for (EquipmentSlot slot : new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            ResourceLocation id;
            ItemStack stack = player.m_6844_(slot);
            if (stack.m_41619_() || !armorEffectsMap.containsKey((id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_())).toString())) continue;
            ArmorEffect effect = armorEffectsMap.get(id.toString());
            speedMultiplier *= effect.speedMultiplier;
            rangeMultiplier *= effect.rangeMultiplier;
        }
        return new double[]{speedMultiplier, rangeMultiplier};
    }
}

