/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.goals;

import com.armilp.ezvcsurvival.config.SoundConfig;
import com.armilp.ezvcsurvival.data.GunshotData;
import com.armilp.ezvcsurvival.data.SoundGroupData;
import com.armilp.ezvcsurvival.events.GunFireListener;
import com.armilp.ezvcsurvival.events.SoundEventTracker;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ReactToSoundGoal
extends Goal {
    private final Mob mob;
    private final double speed;
    private final int range;
    private final List<SoundGroupData> soundGroups;
    private Vec3 lastAttackerPos = null;
    private static final List<ReactToSoundGoal> activeGoals = new CopyOnWriteArrayList<ReactToSoundGoal>();
    public static Vec3 lastPointBlankSoundPos = null;
    public static long lastPointBlankSoundTimestamp = 0L;
    public static String lastPointBlankGunType = null;
    private static final long POINT_BLANK_SOUND_EXPIRATION_MS = 5000L;
    private Vec3 lastPrioritySoundPos = null;
    private long lastPrioritySoundTimestamp = 0L;
    private static final long PRIORITY_SOUND_PERSISTENCE_MS = 4250L;

    public ReactToSoundGoal(Mob mob, double speed, int range, List<SoundGroupData> soundGroups) {
        this.mob = mob;
        this.speed = speed;
        this.range = range;
        this.soundGroups = soundGroups;
        activeGoals.add(this);
    }

    public boolean m_8036_() {
        if (lastPointBlankSoundPos != null && System.currentTimeMillis() - lastPointBlankSoundTimestamp > 5000L) {
            lastPointBlankSoundPos = null;
            lastPointBlankGunType = null;
        }
        Vec3 mobCenterPos = this.mob.m_20182_();
        double effectiveRange = this.range;
        double effectiveSpeed = this.speed;
        String effectiveGunType = null;
        GunshotData gunshotData = GunFireListener.getLastGunshotData();
        if (gunshotData != null) {
            effectiveGunType = gunshotData.gunType.name().toLowerCase();
        } else if (lastPointBlankSoundPos != null && lastPointBlankGunType != null) {
            effectiveGunType = lastPointBlankGunType;
        }
        if (effectiveGunType != null) {
            double speedMultiplier;
            double rangeMultiplier;
            if (lastPointBlankSoundPos != null) {
                rangeMultiplier = SoundConfig.getPointBlankRangeMultiplier(effectiveGunType);
                speedMultiplier = SoundConfig.getPointBlankSpeedMultiplier(effectiveGunType);
            } else {
                rangeMultiplier = SoundConfig.getRangeMultiplier(effectiveGunType);
                speedMultiplier = SoundConfig.getSpeedMultiplier(effectiveGunType);
            }
            effectiveRange = (int)((double)this.range * rangeMultiplier);
            effectiveSpeed = this.speed * speedMultiplier;
        }
        if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
            effectiveRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
        }
        for (SoundGroupData priority : SoundConfig.getPriorityGroups()) {
            for (String soundStr : priority.sounds) {
                ResourceLocation loc = this.toLocation(soundStr);
                Vec3 pos = SoundEventTracker.getLastPlayedPositionForSound(loc);
                if (pos == null) continue;
                double prRange = priority.rangeMultiplier * (double)this.range;
                if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
                    prRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
                }
                return mobCenterPos.m_82554_(pos) <= prRange;
            }
        }
        boolean gunshotTriggered = gunshotData != null && mobCenterPos.m_82554_(gunshotData.position) <= effectiveRange;
        Vec3 soundEventPos = null;
        double groupRangeMult = 1.0;
        block2: for (SoundGroupData group : this.soundGroups) {
            for (String soundStr : group.sounds) {
                ResourceLocation loc = this.toLocation(soundStr);
                Vec3 pos = SoundEventTracker.getLastPlayedPositionForSound(loc);
                if (pos == null) continue;
                soundEventPos = pos;
                groupRangeMult = group.rangeMultiplier;
                break block2;
            }
        }
        boolean soundTriggered = false;
        if (soundEventPos != null) {
            double grpRange = (double)this.range * groupRangeMult;
            if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
                grpRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
            }
            soundTriggered = mobCenterPos.m_82554_(soundEventPos) <= grpRange;
        }
        boolean pointBlankTriggered = lastPointBlankSoundPos != null && mobCenterPos.m_82554_(lastPointBlankSoundPos) <= effectiveRange;
        boolean hurtTriggered = !(this.mob instanceof Monster) && this.lastAttackerPos != null;
        return gunshotTriggered || soundTriggered || pointBlankTriggered || hurtTriggered;
    }

    public void m_8056_() {
        this.updateNavigation();
    }

    public void m_8037_() {
        this.updateNavigation();
    }

    public void m_8041_() {
        activeGoals.remove((Object)this);
    }

    public void onHurt(Vec3 attackerPos) {
        this.lastAttackerPos = attackerPos;
    }

    private void updateNavigation() {
        if (lastPointBlankSoundPos != null && System.currentTimeMillis() - lastPointBlankSoundTimestamp > 5000L) {
            lastPointBlankSoundPos = null;
            lastPointBlankGunType = null;
        }
        Vec3 currentPos = this.mob.m_20182_();
        Vec3 target = null;
        double effectiveRange = this.range;
        double effectiveSpeed = this.speed;
        String effectiveGunType = null;
        GunshotData gunshotData = GunFireListener.getLastGunshotData();
        if (gunshotData != null) {
            effectiveGunType = gunshotData.gunType.name().toLowerCase();
        } else if (lastPointBlankSoundPos != null && lastPointBlankGunType != null) {
            effectiveGunType = lastPointBlankGunType;
        }
        if (effectiveGunType != null) {
            double speedMultiplier;
            double rangeMultiplier;
            if (lastPointBlankSoundPos != null) {
                rangeMultiplier = SoundConfig.getPointBlankRangeMultiplier(effectiveGunType);
                speedMultiplier = SoundConfig.getPointBlankSpeedMultiplier(effectiveGunType);
            } else {
                rangeMultiplier = SoundConfig.getRangeMultiplier(effectiveGunType);
                speedMultiplier = SoundConfig.getSpeedMultiplier(effectiveGunType);
            }
            effectiveRange = (double)this.range * rangeMultiplier;
            effectiveSpeed = this.speed * speedMultiplier;
        }
        if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
            effectiveRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
        }
        Vec3 prioritySoundPos = null;
        double priorityRange = 0.0;
        double prioritySpeed = 0.0;
        for (SoundGroupData priority : SoundConfig.getPriorityGroups()) {
            for (String soundStr : priority.sounds) {
                ResourceLocation loc = this.toLocation(soundStr);
                Vec3 pos = SoundEventTracker.getLastPlayedPositionForSound(loc);
                if (pos == null) continue;
                this.lastPrioritySoundPos = pos;
                this.lastPrioritySoundTimestamp = System.currentTimeMillis();
            }
        }
        if (this.lastPrioritySoundPos != null && System.currentTimeMillis() - this.lastPrioritySoundTimestamp <= 4250L) {
            prioritySoundPos = this.lastPrioritySoundPos;
            block2: for (SoundGroupData priority : SoundConfig.getPriorityGroups()) {
                for (String soundStr : priority.sounds) {
                    if (SoundEventTracker.getLastPlayedPositionForSound(this.toLocation(soundStr)) == null && this.lastPrioritySoundPos == null) continue;
                    priorityRange = priority.rangeMultiplier * (double)this.range;
                    prioritySpeed = priority.speedMultiplier * this.speed;
                    if (!this.mob.m_9236_().m_46471_() && !this.mob.m_9236_().m_46470_()) continue block2;
                    priorityRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
                    continue block2;
                }
            }
            if (currentPos.m_82554_(prioritySoundPos) <= priorityRange) {
                if (this.mob instanceof Monster) {
                    this.mob.m_21573_().m_26519_(prioritySoundPos.f_82479_, prioritySoundPos.f_82480_, prioritySoundPos.f_82481_, prioritySpeed);
                } else {
                    Vec3 directionAway = currentPos.m_82546_(prioritySoundPos).m_82541_();
                    Vec3 fleeTarget = currentPos.m_82549_(directionAway.m_82490_(priorityRange));
                    this.mob.m_21573_().m_26519_(fleeTarget.f_82479_, fleeTarget.f_82480_, fleeTarget.f_82481_, prioritySpeed);
                }
                return;
            }
        }
        Vec3 soundEventPos = null;
        double groupRangeMult = 1.0;
        double groupSpeedMult = 1.0;
        block4: for (SoundGroupData group : this.soundGroups) {
            for (String soundStr : group.sounds) {
                ResourceLocation loc = this.toLocation(soundStr);
                Vec3 pos = SoundEventTracker.getLastPlayedPositionForSound(loc);
                if (pos == null) continue;
                soundEventPos = pos;
                groupRangeMult = group.rangeMultiplier;
                groupSpeedMult = group.speedMultiplier;
                break block4;
            }
        }
        if (soundEventPos != null) {
            double grpRange = (double)this.range * groupRangeMult;
            double grpSpeed = this.speed * groupSpeedMult;
            if (this.mob.m_9236_().m_46471_() || this.mob.m_9236_().m_46470_()) {
                grpRange *= ((Double)SoundConfig.THUNDER_RANGE_MULTIPLIER.get()).doubleValue();
            }
            if (currentPos.m_82554_(soundEventPos) <= grpRange) {
                if (this.mob instanceof Monster) {
                    this.mob.m_21573_().m_26519_(soundEventPos.f_82479_, soundEventPos.f_82480_, soundEventPos.f_82481_, grpSpeed);
                } else {
                    Vec3 directionAway = currentPos.m_82546_(soundEventPos).m_82541_();
                    Vec3 fleeTarget = currentPos.m_82549_(directionAway.m_82490_(grpRange));
                    this.mob.m_21573_().m_26519_(fleeTarget.f_82479_, fleeTarget.f_82480_, fleeTarget.f_82481_, grpSpeed);
                }
                return;
            }
        }
        if (this.mob instanceof Monster) {
            if (gunshotData != null && currentPos.m_82554_(gunshotData.position) <= effectiveRange) {
                target = new Vec3(gunshotData.position.f_82479_, this.mob.m_20186_(), gunshotData.position.f_82481_);
            } else if (lastPointBlankSoundPos != null && currentPos.m_82554_(lastPointBlankSoundPos) <= effectiveRange) {
                target = new Vec3(ReactToSoundGoal.lastPointBlankSoundPos.f_82479_, this.mob.m_20186_(), ReactToSoundGoal.lastPointBlankSoundPos.f_82481_);
            }
            if (target != null) {
                this.mob.m_21573_().m_26519_(target.f_82479_, target.f_82480_, target.f_82481_, effectiveSpeed);
                if (currentPos.m_82554_(target) < 1.0) {
                    lastPointBlankSoundPos = null;
                    lastPointBlankGunType = null;
                    this.m_8041_();
                }
            }
        } else {
            Vec3 dangerPos = null;
            if (gunshotData != null && currentPos.m_82554_(gunshotData.position) <= effectiveRange) {
                dangerPos = gunshotData.position;
            } else if (lastPointBlankSoundPos != null && currentPos.m_82554_(lastPointBlankSoundPos) <= effectiveRange) {
                dangerPos = lastPointBlankSoundPos;
            }
            if (dangerPos != null) {
                Vec3 directionAway = currentPos.m_82546_(dangerPos).m_82541_();
                Vec3 fleeTarget = currentPos.m_82549_(directionAway.m_82490_(effectiveRange));
                this.mob.m_21573_().m_26519_(fleeTarget.f_82479_, fleeTarget.f_82480_, fleeTarget.f_82481_, effectiveSpeed);
            }
        }
    }

    private ResourceLocation toLocation(String soundStr) {
        if (soundStr.contains(":")) {
            return new ResourceLocation(soundStr);
        }
        return new ResourceLocation("minecraft", soundStr);
    }

    @Mod.EventBusSubscriber(modid="ezvcsurvival")
    public static class ReactToSoundGoalEventHandler {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            for (ReactToSoundGoal goal : activeGoals) {
                if (event.getEntity() != goal.mob || goal.mob instanceof Monster || event.getSource().m_7639_() == null) continue;
                goal.onHurt(event.getSource().m_7639_().m_20182_());
            }
        }
    }
}

