/*
 * Decompiled with CFR 0.152.
 */
package com.armilp.ezvcsurvival.goals;

import com.armilp.ezvcsurvival.Plugin;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class RunawayVoiceGoal
extends Goal {
    private final Animal mob;
    private final double speedModifier;
    private final int voiceDetectionRange;
    private Player targetPlayer;
    private final double threshold;
    private BlockPos targetSoundPosition;
    private double targetSoundSpeed;
    private int ambientSoundCount;
    private int fleeTicks = 0;
    private int distanceCovered = 0;

    public RunawayVoiceGoal(Animal mob, double speedModifier, int detectionRange, double threshold) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.voiceDetectionRange = detectionRange;
        this.threshold = threshold;
        this.ambientSoundCount = 0;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        this.targetPlayer = this.findNearestPlayer();
        this.targetSoundPosition = Plugin.getLastSoundLocation(this.mob.m_20183_(), this.voiceDetectionRange);
        this.targetSoundSpeed = Plugin.getLastSoundSpeed(this.mob.m_20183_(), this.voiceDetectionRange);
        return this.targetSoundPosition != null;
    }

    public boolean m_8045_() {
        return this.targetSoundPosition != null && !this.mob.m_21573_().m_26571_();
    }

    public void m_8056_() {
        if (this.targetSoundPosition != null) {
            this.fleeFrom(Vec3.m_82512_((Vec3i)this.targetSoundPosition));
        }
    }

    public void m_8037_() {
        if (this.targetSoundPosition != null) {
            this.handleSoundThreat();
        }
    }

    public void m_8041_() {
        this.targetSoundPosition = null;
        this.targetPlayer = null;
        this.ambientSoundCount = 0;
        this.mob.m_21573_().m_26573_();
    }

    private Player findNearestPlayer() {
        return ((ServerLevel)this.mob.m_9236_()).m_45930_((Entity)this.mob, (double)this.voiceDetectionRange);
    }

    private void handleSoundThreat() {
        ++this.distanceCovered;
        if (this.distanceCovered > 10 && this.distanceCovered % 20 == 0) {
            this.mob.m_21573_().m_26573_();
            this.mob.m_21563_().m_24950_(Vec3.m_82512_((Vec3i)this.targetSoundPosition).f_82479_, Vec3.m_82512_((Vec3i)this.targetSoundPosition).f_82480_, Vec3.m_82512_((Vec3i)this.targetSoundPosition).f_82481_, 30.0f, 30.0f);
        }
        if (this.targetSoundPosition == null || this.mob.m_20183_().m_123331_((Vec3i)this.targetSoundPosition) > this.threshold * this.threshold) {
            this.targetSoundPosition = Plugin.getLastSoundLocation(this.mob.m_20183_(), this.voiceDetectionRange);
            this.targetSoundSpeed = Plugin.getLastSoundSpeed(this.mob.m_20183_(), this.voiceDetectionRange);
        } else {
            this.fleeFrom(Vec3.m_82512_((Vec3i)this.targetSoundPosition));
        }
    }

    private void fleeFrom(Vec3 dangerPosition) {
        ++this.fleeTicks;
        Vec3 fleeDirection = this.mob.m_20182_().m_82546_(dangerPosition).m_82541_().m_82490_(20.0);
        double randomOffsetX = (this.mob.m_217043_().m_188500_() - 0.5) * 5.0;
        double randomOffsetZ = (this.mob.m_217043_().m_188500_() - 0.5) * 5.0;
        Vec3 fleeTarget = this.mob.m_20182_().m_82549_(fleeDirection).m_82520_(randomOffsetX, 0.0, randomOffsetZ);
        if (this.isDangerousBlock(new BlockPos((int)fleeTarget.f_82479_, (int)fleeTarget.f_82480_, (int)fleeTarget.f_82481_))) {
            fleeDirection = fleeDirection.m_82520_(this.mob.m_217043_().m_188500_() * 5.0, 0.0, this.mob.m_217043_().m_188500_() * 5.0);
            fleeTarget = this.mob.m_20182_().m_82549_(fleeDirection);
        }
        this.mob.m_21573_().m_26519_(fleeTarget.f_82479_, fleeTarget.f_82480_, fleeTarget.f_82481_, this.speedModifier);
        if (this.ambientSoundCount < 2 && this.mob.m_217043_().m_188500_() < 0.5) {
            this.mob.m_8032_();
            ++this.ambientSoundCount;
        }
    }

    private boolean isDangerousBlock(BlockPos pos) {
        ServerLevel level = (ServerLevel)this.mob.m_9236_();
        BlockState blockState = level.m_8055_(pos);
        return !blockState.m_60819_().m_76178_() || !blockState.m_280296_();
    }
}

